package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FinishCurrentProjectNode invokes the market.FinishCurrentProjectNode API synchronously
func (client *Client) FinishCurrentProjectNode(request *FinishCurrentProjectNodeRequest) (response *FinishCurrentProjectNodeResponse, err error) {
	response = CreateFinishCurrentProjectNodeResponse()
	err = client.DoAction(request, response)
	return
}

// FinishCurrentProjectNodeWithChan invokes the market.FinishCurrentProjectNode API asynchronously
func (client *Client) FinishCurrentProjectNodeWithChan(request *FinishCurrentProjectNodeRequest) (<-chan *FinishCurrentProjectNodeResponse, <-chan error) {
	responseChan := make(chan *FinishCurrentProjectNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FinishCurrentProjectNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FinishCurrentProjectNodeWithCallback invokes the market.FinishCurrentProjectNode API asynchronously
func (client *Client) FinishCurrentProjectNodeWithCallback(request *FinishCurrentProjectNodeRequest, callback func(response *FinishCurrentProjectNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FinishCurrentProjectNodeResponse
		var err error
		defer close(result)
		response, err = client.FinishCurrentProjectNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FinishCurrentProjectNodeRequest is the request struct for api FinishCurrentProjectNode
type FinishCurrentProjectNodeRequest struct {
	*requests.RpcRequest
	TemplateForm string           `position:"Query" name:"TemplateForm"`
	Remark       string           `position:"Query" name:"Remark"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	NodeId       requests.Integer `position:"Query" name:"NodeId"`
}

// FinishCurrentProjectNodeResponse is the response struct for api FinishCurrentProjectNode
type FinishCurrentProjectNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateFinishCurrentProjectNodeRequest creates a request to invoke FinishCurrentProjectNode API
func CreateFinishCurrentProjectNodeRequest() (request *FinishCurrentProjectNodeRequest) {
	request = &FinishCurrentProjectNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "FinishCurrentProjectNode", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFinishCurrentProjectNodeResponse creates a response to parse from FinishCurrentProjectNode response
func CreateFinishCurrentProjectNodeResponse() (response *FinishCurrentProjectNodeResponse) {
	response = &FinishCurrentProjectNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
