package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeviceGroupAuthorizedBizChain invokes the lto.ListDeviceGroupAuthorizedBizChain API synchronously
func (client *Client) ListDeviceGroupAuthorizedBizChain(request *ListDeviceGroupAuthorizedBizChainRequest) (response *ListDeviceGroupAuthorizedBizChainResponse, err error) {
	response = CreateListDeviceGroupAuthorizedBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeviceGroupAuthorizedBizChainWithChan invokes the lto.ListDeviceGroupAuthorizedBizChain API asynchronously
func (client *Client) ListDeviceGroupAuthorizedBizChainWithChan(request *ListDeviceGroupAuthorizedBizChainRequest) (<-chan *ListDeviceGroupAuthorizedBizChainResponse, <-chan error) {
	responseChan := make(chan *ListDeviceGroupAuthorizedBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeviceGroupAuthorizedBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeviceGroupAuthorizedBizChainWithCallback invokes the lto.ListDeviceGroupAuthorizedBizChain API asynchronously
func (client *Client) ListDeviceGroupAuthorizedBizChainWithCallback(request *ListDeviceGroupAuthorizedBizChainRequest, callback func(response *ListDeviceGroupAuthorizedBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeviceGroupAuthorizedBizChainResponse
		var err error
		defer close(result)
		response, err = client.ListDeviceGroupAuthorizedBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeviceGroupAuthorizedBizChainRequest is the request struct for api ListDeviceGroupAuthorizedBizChain
type ListDeviceGroupAuthorizedBizChainRequest struct {
	*requests.RpcRequest
	DeviceGroupId string `position:"Query" name:"DeviceGroupId"`
}

// ListDeviceGroupAuthorizedBizChainResponse is the response struct for api ListDeviceGroupAuthorizedBizChain
type ListDeviceGroupAuthorizedBizChainResponse struct {
	*responses.BaseResponse
	Code           string                      `json:"Code" xml:"Code"`
	HttpStatusCode int                         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                      `json:"Message" xml:"Message"`
	RequestId      string                      `json:"RequestId" xml:"RequestId"`
	Success        bool                        `json:"Success" xml:"Success"`
	Data           []DeviceGroupAuthorizedInfo `json:"Data" xml:"Data"`
}

// CreateListDeviceGroupAuthorizedBizChainRequest creates a request to invoke ListDeviceGroupAuthorizedBizChain API
func CreateListDeviceGroupAuthorizedBizChainRequest() (request *ListDeviceGroupAuthorizedBizChainRequest) {
	request = &ListDeviceGroupAuthorizedBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListDeviceGroupAuthorizedBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateListDeviceGroupAuthorizedBizChainResponse creates a response to parse from ListDeviceGroupAuthorizedBizChain response
func CreateListDeviceGroupAuthorizedBizChainResponse() (response *ListDeviceGroupAuthorizedBizChainResponse) {
	response = &ListDeviceGroupAuthorizedBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
