package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAllBizChainContract invokes the lto.ListAllBizChainContract API synchronously
func (client *Client) ListAllBizChainContract(request *ListAllBizChainContractRequest) (response *ListAllBizChainContractResponse, err error) {
	response = CreateListAllBizChainContractResponse()
	err = client.DoAction(request, response)
	return
}

// ListAllBizChainContractWithChan invokes the lto.ListAllBizChainContract API asynchronously
func (client *Client) ListAllBizChainContractWithChan(request *ListAllBizChainContractRequest) (<-chan *ListAllBizChainContractResponse, <-chan error) {
	responseChan := make(chan *ListAllBizChainContractResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAllBizChainContract(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAllBizChainContractWithCallback invokes the lto.ListAllBizChainContract API asynchronously
func (client *Client) ListAllBizChainContractWithCallback(request *ListAllBizChainContractRequest, callback func(response *ListAllBizChainContractResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAllBizChainContractResponse
		var err error
		defer close(result)
		response, err = client.ListAllBizChainContract(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAllBizChainContractRequest is the request struct for api ListAllBizChainContract
type ListAllBizChainContractRequest struct {
	*requests.RpcRequest
	BizChainId string `position:"Query" name:"BizChainId"`
}

// ListAllBizChainContractResponse is the response struct for api ListAllBizChainContract
type ListAllBizChainContractResponse struct {
	*responses.BaseResponse
	Code           string         `json:"Code" xml:"Code"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string         `json:"Message" xml:"Message"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Data           []ContractInfo `json:"Data" xml:"Data"`
}

// CreateListAllBizChainContractRequest creates a request to invoke ListAllBizChainContract API
func CreateListAllBizChainContractRequest() (request *ListAllBizChainContractRequest) {
	request = &ListAllBizChainContractRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListAllBizChainContract", "", "")
	request.Method = requests.POST
	return
}

// CreateListAllBizChainContractResponse creates a response to parse from ListAllBizChainContract response
func CreateListAllBizChainContractResponse() (response *ListAllBizChainContractResponse) {
	response = &ListAllBizChainContractResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
