package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnAuthorizeDevice invokes the ltl.UnAuthorizeDevice API synchronously
func (client *Client) UnAuthorizeDevice(request *UnAuthorizeDeviceRequest) (response *UnAuthorizeDeviceResponse, err error) {
	response = CreateUnAuthorizeDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UnAuthorizeDeviceWithChan invokes the ltl.UnAuthorizeDevice API asynchronously
func (client *Client) UnAuthorizeDeviceWithChan(request *UnAuthorizeDeviceRequest) (<-chan *UnAuthorizeDeviceResponse, <-chan error) {
	responseChan := make(chan *UnAuthorizeDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnAuthorizeDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnAuthorizeDeviceWithCallback invokes the ltl.UnAuthorizeDevice API asynchronously
func (client *Client) UnAuthorizeDeviceWithCallback(request *UnAuthorizeDeviceRequest, callback func(response *UnAuthorizeDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnAuthorizeDeviceResponse
		var err error
		defer close(result)
		response, err = client.UnAuthorizeDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnAuthorizeDeviceRequest is the request struct for api UnAuthorizeDevice
type UnAuthorizeDeviceRequest struct {
	*requests.RpcRequest
	ApiVersion    string `position:"Query" name:"ApiVersion"`
	DeviceId      string `position:"Query" name:"DeviceId"`
	DeviceGroupId string `position:"Query" name:"DeviceGroupId"`
	BizChainId    string `position:"Query" name:"BizChainId"`
}

// UnAuthorizeDeviceResponse is the response struct for api UnAuthorizeDevice
type UnAuthorizeDeviceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUnAuthorizeDeviceRequest creates a request to invoke UnAuthorizeDevice API
func CreateUnAuthorizeDeviceRequest() (request *UnAuthorizeDeviceRequest) {
	request = &UnAuthorizeDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "UnAuthorizeDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateUnAuthorizeDeviceResponse creates a response to parse from UnAuthorizeDevice response
func CreateUnAuthorizeDeviceResponse() (response *UnAuthorizeDeviceResponse) {
	response = &UnAuthorizeDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
