package location

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEndpoints invokes the location.DescribeEndpoints API synchronously
// api document: https://help.aliyun.com/api/location/describeendpoints.html
func (client *Client) DescribeEndpoints(request *DescribeEndpointsRequest) (response *DescribeEndpointsResponse, err error) {
	response = CreateDescribeEndpointsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEndpointsWithChan invokes the location.DescribeEndpoints API asynchronously
// api document: https://help.aliyun.com/api/location/describeendpoints.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEndpointsWithChan(request *DescribeEndpointsRequest) (<-chan *DescribeEndpointsResponse, <-chan error) {
	responseChan := make(chan *DescribeEndpointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEndpoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEndpointsWithCallback invokes the location.DescribeEndpoints API asynchronously
// api document: https://help.aliyun.com/api/location/describeendpoints.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEndpointsWithCallback(request *DescribeEndpointsRequest, callback func(response *DescribeEndpointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEndpointsResponse
		var err error
		defer close(result)
		response, err = client.DescribeEndpoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEndpointsRequest is the request struct for api DescribeEndpoints
type DescribeEndpointsRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Query" name:"ServiceCode"`
	Id          string `position:"Query" name:"Id"`
	Type        string `position:"Query" name:"Type"`
}

// DescribeEndpointsResponse is the response struct for api DescribeEndpoints
type DescribeEndpointsResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	Endpoints Endpoints `json:"Endpoints" xml:"Endpoints"`
}

// CreateDescribeEndpointsRequest creates a request to invoke DescribeEndpoints API
func CreateDescribeEndpointsRequest() (request *DescribeEndpointsRequest) {
	request = &DescribeEndpointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Location", "2015-06-12", "DescribeEndpoints", "location", "openAPI")
	return
}

// CreateDescribeEndpointsResponse creates a response to parse from DescribeEndpoints response
func CreateDescribeEndpointsResponse() (response *DescribeEndpointsResponse) {
	response = &DescribeEndpointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
