package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveRecordVodConfig invokes the live.UpdateLiveRecordVodConfig API synchronously
func (client *Client) UpdateLiveRecordVodConfig(request *UpdateLiveRecordVodConfigRequest) (response *UpdateLiveRecordVodConfigResponse, err error) {
	response = CreateUpdateLiveRecordVodConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveRecordVodConfigWithChan invokes the live.UpdateLiveRecordVodConfig API asynchronously
func (client *Client) UpdateLiveRecordVodConfigWithChan(request *UpdateLiveRecordVodConfigRequest) (<-chan *UpdateLiveRecordVodConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveRecordVodConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveRecordVodConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveRecordVodConfigWithCallback invokes the live.UpdateLiveRecordVodConfig API asynchronously
func (client *Client) UpdateLiveRecordVodConfigWithCallback(request *UpdateLiveRecordVodConfigRequest, callback func(response *UpdateLiveRecordVodConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveRecordVodConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveRecordVodConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveRecordVodConfigRequest is the request struct for api UpdateLiveRecordVodConfig
type UpdateLiveRecordVodConfigRequest struct {
	*requests.RpcRequest
	AutoCompose                string           `position:"Query" name:"AutoCompose"`
	ComposeVodTranscodeGroupId string           `position:"Query" name:"ComposeVodTranscodeGroupId"`
	StorageLocation            string           `position:"Query" name:"StorageLocation"`
	AppName                    string           `position:"Query" name:"AppName"`
	OnDemand                   requests.Integer `position:"Query" name:"OnDemand"`
	StreamName                 string           `position:"Query" name:"StreamName"`
	VodTranscodeGroupId        string           `position:"Query" name:"VodTranscodeGroupId"`
	DomainName                 string           `position:"Query" name:"DomainName"`
	CycleDuration              requests.Integer `position:"Query" name:"CycleDuration"`
	OwnerId                    requests.Integer `position:"Query" name:"OwnerId"`
}

// UpdateLiveRecordVodConfigResponse is the response struct for api UpdateLiveRecordVodConfig
type UpdateLiveRecordVodConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveRecordVodConfigRequest creates a request to invoke UpdateLiveRecordVodConfig API
func CreateUpdateLiveRecordVodConfigRequest() (request *UpdateLiveRecordVodConfigRequest) {
	request = &UpdateLiveRecordVodConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveRecordVodConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveRecordVodConfigResponse creates a response to parse from UpdateLiveRecordVodConfig response
func CreateUpdateLiveRecordVodConfigResponse() (response *UpdateLiveRecordVodConfigResponse) {
	response = &UpdateLiveRecordVodConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
