package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLiveDelayConfig invokes the live.CreateLiveDelayConfig API synchronously
func (client *Client) CreateLiveDelayConfig(request *CreateLiveDelayConfigRequest) (response *CreateLiveDelayConfigResponse, err error) {
	response = CreateCreateLiveDelayConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLiveDelayConfigWithChan invokes the live.CreateLiveDelayConfig API asynchronously
func (client *Client) CreateLiveDelayConfigWithChan(request *CreateLiveDelayConfigRequest) (<-chan *CreateLiveDelayConfigResponse, <-chan error) {
	responseChan := make(chan *CreateLiveDelayConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLiveDelayConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLiveDelayConfigWithCallback invokes the live.CreateLiveDelayConfig API asynchronously
func (client *Client) CreateLiveDelayConfigWithCallback(request *CreateLiveDelayConfigRequest, callback func(response *CreateLiveDelayConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLiveDelayConfigResponse
		var err error
		defer close(result)
		response, err = client.CreateLiveDelayConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLiveDelayConfigRequest is the request struct for api CreateLiveDelayConfig
type CreateLiveDelayConfigRequest struct {
	*requests.RpcRequest
	DelayTime       requests.Integer `position:"Query" name:"DelayTime"`
	Stream          string           `position:"Query" name:"Stream"`
	App             string           `position:"Query" name:"App"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	TaskTriggerMode string           `position:"Query" name:"TaskTriggerMode"`
	Domain          string           `position:"Query" name:"Domain"`
}

// CreateLiveDelayConfigResponse is the response struct for api CreateLiveDelayConfig
type CreateLiveDelayConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateLiveDelayConfigRequest creates a request to invoke CreateLiveDelayConfig API
func CreateCreateLiveDelayConfigRequest() (request *CreateLiveDelayConfigRequest) {
	request = &CreateLiveDelayConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateLiveDelayConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLiveDelayConfigResponse creates a response to parse from CreateLiveDelayConfig response
func CreateCreateLiveDelayConfigResponse() (response *CreateLiveDelayConfigResponse) {
	response = &CreateLiveDelayConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
