package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceRecordLifeCycle invokes the linkvisual.QueryDeviceRecordLifeCycle API synchronously
func (client *Client) QueryDeviceRecordLifeCycle(request *QueryDeviceRecordLifeCycleRequest) (response *QueryDeviceRecordLifeCycleResponse, err error) {
	response = CreateQueryDeviceRecordLifeCycleResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceRecordLifeCycleWithChan invokes the linkvisual.QueryDeviceRecordLifeCycle API asynchronously
func (client *Client) QueryDeviceRecordLifeCycleWithChan(request *QueryDeviceRecordLifeCycleRequest) (<-chan *QueryDeviceRecordLifeCycleResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceRecordLifeCycleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceRecordLifeCycle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceRecordLifeCycleWithCallback invokes the linkvisual.QueryDeviceRecordLifeCycle API asynchronously
func (client *Client) QueryDeviceRecordLifeCycleWithCallback(request *QueryDeviceRecordLifeCycleRequest, callback func(response *QueryDeviceRecordLifeCycleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceRecordLifeCycleResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceRecordLifeCycle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceRecordLifeCycleRequest is the request struct for api QueryDeviceRecordLifeCycle
type QueryDeviceRecordLifeCycleRequest struct {
	*requests.RpcRequest
	DeviceList  *[]string `position:"Query" name:"DeviceList"  type:"Repeated"`
	ApiProduct  string    `position:"Body" name:"ApiProduct"`
	ApiRevision string    `position:"Body" name:"ApiRevision"`
}

// QueryDeviceRecordLifeCycleResponse is the response struct for api QueryDeviceRecordLifeCycle
type QueryDeviceRecordLifeCycleResponse struct {
	*responses.BaseResponse
	Code         int        `json:"Code" xml:"Code"`
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	ErrorMessage string     `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool       `json:"Success" xml:"Success"`
	Data         []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryDeviceRecordLifeCycleRequest creates a request to invoke QueryDeviceRecordLifeCycle API
func CreateQueryDeviceRecordLifeCycleRequest() (request *QueryDeviceRecordLifeCycleRequest) {
	request = &QueryDeviceRecordLifeCycleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryDeviceRecordLifeCycle", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceRecordLifeCycleResponse creates a response to parse from QueryDeviceRecordLifeCycle response
func CreateQueryDeviceRecordLifeCycleResponse() (response *QueryDeviceRecordLifeCycleResponse) {
	response = &QueryDeviceRecordLifeCycleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
