package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFaceUserToUserGroup invokes the linkvisual.AddFaceUserToUserGroup API synchronously
func (client *Client) AddFaceUserToUserGroup(request *AddFaceUserToUserGroupRequest) (response *AddFaceUserToUserGroupResponse, err error) {
	response = CreateAddFaceUserToUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddFaceUserToUserGroupWithChan invokes the linkvisual.AddFaceUserToUserGroup API asynchronously
func (client *Client) AddFaceUserToUserGroupWithChan(request *AddFaceUserToUserGroupRequest) (<-chan *AddFaceUserToUserGroupResponse, <-chan error) {
	responseChan := make(chan *AddFaceUserToUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFaceUserToUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFaceUserToUserGroupWithCallback invokes the linkvisual.AddFaceUserToUserGroup API asynchronously
func (client *Client) AddFaceUserToUserGroupWithCallback(request *AddFaceUserToUserGroupRequest, callback func(response *AddFaceUserToUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFaceUserToUserGroupResponse
		var err error
		defer close(result)
		response, err = client.AddFaceUserToUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFaceUserToUserGroupRequest is the request struct for api AddFaceUserToUserGroup
type AddFaceUserToUserGroupRequest struct {
	*requests.RpcRequest
	IsolationId string `position:"Query" name:"IsolationId"`
	UserId      string `position:"Query" name:"UserId"`
	UserGroupId string `position:"Query" name:"UserGroupId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// AddFaceUserToUserGroupResponse is the response struct for api AddFaceUserToUserGroup
type AddFaceUserToUserGroupResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateAddFaceUserToUserGroupRequest creates a request to invoke AddFaceUserToUserGroup API
func CreateAddFaceUserToUserGroupRequest() (request *AddFaceUserToUserGroupRequest) {
	request = &AddFaceUserToUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "AddFaceUserToUserGroup", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddFaceUserToUserGroupResponse creates a response to parse from AddFaceUserToUserGroup response
func CreateAddFaceUserToUserGroupResponse() (response *AddFaceUserToUserGroupResponse) {
	response = &AddFaceUserToUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
