package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSpeech invokes the iot.DeleteSpeech API synchronously
func (client *Client) DeleteSpeech(request *DeleteSpeechRequest) (response *DeleteSpeechResponse, err error) {
	response = CreateDeleteSpeechResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSpeechWithChan invokes the iot.DeleteSpeech API asynchronously
func (client *Client) DeleteSpeechWithChan(request *DeleteSpeechRequest) (<-chan *DeleteSpeechResponse, <-chan error) {
	responseChan := make(chan *DeleteSpeechResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSpeech(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSpeechWithCallback invokes the iot.DeleteSpeech API asynchronously
func (client *Client) DeleteSpeechWithCallback(request *DeleteSpeechRequest, callback func(response *DeleteSpeechResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSpeechResponse
		var err error
		defer close(result)
		response, err = client.DeleteSpeech(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSpeechRequest is the request struct for api DeleteSpeech
type DeleteSpeechRequest struct {
	*requests.RpcRequest
	IotInstanceId  string    `position:"Body" name:"IotInstanceId"`
	SpeechCodeList *[]string `position:"Body" name:"SpeechCodeList"  type:"Repeated"`
	ApiProduct     string    `position:"Body" name:"ApiProduct"`
	ApiRevision    string    `position:"Body" name:"ApiRevision"`
}

// DeleteSpeechResponse is the response struct for api DeleteSpeech
type DeleteSpeechResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteSpeechRequest creates a request to invoke DeleteSpeech API
func CreateDeleteSpeechRequest() (request *DeleteSpeechRequest) {
	request = &DeleteSpeechRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteSpeech", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSpeechResponse creates a response to parse from DeleteSpeech response
func CreateDeleteSpeechResponse() (response *DeleteSpeechResponse) {
	response = &DeleteSpeechResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
