package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSAMLProvider invokes the ims.UpdateSAMLProvider API synchronously
func (client *Client) UpdateSAMLProvider(request *UpdateSAMLProviderRequest) (response *UpdateSAMLProviderResponse, err error) {
	response = CreateUpdateSAMLProviderResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSAMLProviderWithChan invokes the ims.UpdateSAMLProvider API asynchronously
func (client *Client) UpdateSAMLProviderWithChan(request *UpdateSAMLProviderRequest) (<-chan *UpdateSAMLProviderResponse, <-chan error) {
	responseChan := make(chan *UpdateSAMLProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSAMLProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSAMLProviderWithCallback invokes the ims.UpdateSAMLProvider API asynchronously
func (client *Client) UpdateSAMLProviderWithCallback(request *UpdateSAMLProviderRequest, callback func(response *UpdateSAMLProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSAMLProviderResponse
		var err error
		defer close(result)
		response, err = client.UpdateSAMLProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSAMLProviderRequest is the request struct for api UpdateSAMLProvider
type UpdateSAMLProviderRequest struct {
	*requests.RpcRequest
	AkProxySuffix                  string `position:"Query" name:"AkProxySuffix"`
	NewEncodedSAMLMetadataDocument string `position:"Query" name:"NewEncodedSAMLMetadataDocument"`
	SAMLProviderName               string `position:"Query" name:"SAMLProviderName"`
	NewDescription                 string `position:"Query" name:"NewDescription"`
	NewSAMLMetadataDocument        string `position:"Query" name:"NewSAMLMetadataDocument"`
}

// UpdateSAMLProviderResponse is the response struct for api UpdateSAMLProvider
type UpdateSAMLProviderResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	SAMLProvider SAMLProvider `json:"SAMLProvider" xml:"SAMLProvider"`
}

// CreateUpdateSAMLProviderRequest creates a request to invoke UpdateSAMLProvider API
func CreateUpdateSAMLProviderRequest() (request *UpdateSAMLProviderRequest) {
	request = &UpdateSAMLProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "UpdateSAMLProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSAMLProviderResponse creates a response to parse from UpdateSAMLProvider response
func CreateUpdateSAMLProviderResponse() (response *UpdateSAMLProviderResponse) {
	response = &UpdateSAMLProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
