package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDepartment invokes the idrsservice.DeleteDepartment API synchronously
func (client *Client) DeleteDepartment(request *DeleteDepartmentRequest) (response *DeleteDepartmentResponse, err error) {
	response = CreateDeleteDepartmentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDepartmentWithChan invokes the idrsservice.DeleteDepartment API asynchronously
func (client *Client) DeleteDepartmentWithChan(request *DeleteDepartmentRequest) (<-chan *DeleteDepartmentResponse, <-chan error) {
	responseChan := make(chan *DeleteDepartmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDepartment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDepartmentWithCallback invokes the idrsservice.DeleteDepartment API asynchronously
func (client *Client) DeleteDepartmentWithCallback(request *DeleteDepartmentRequest, callback func(response *DeleteDepartmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDepartmentResponse
		var err error
		defer close(result)
		response, err = client.DeleteDepartment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDepartmentRequest is the request struct for api DeleteDepartment
type DeleteDepartmentRequest struct {
	*requests.RpcRequest
	Id string `position:"Query" name:"Id"`
}

// DeleteDepartmentResponse is the response struct for api DeleteDepartment
type DeleteDepartmentResponse struct {
	*responses.BaseResponse
	Code      string                 `json:"Code" xml:"Code"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDepartmentRequest creates a request to invoke DeleteDepartment API
func CreateDeleteDepartmentRequest() (request *DeleteDepartmentRequest) {
	request = &DeleteDepartmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "DeleteDepartment", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDepartmentResponse creates a response to parse from DeleteDepartment response
func CreateDeleteDepartmentResponse() (response *DeleteDepartmentResponse) {
	response = &DeleteDepartmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
