package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRestorePlan invokes the hbase.CreateRestorePlan API synchronously
func (client *Client) CreateRestorePlan(request *CreateRestorePlanRequest) (response *CreateRestorePlanResponse, err error) {
	response = CreateCreateRestorePlanResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRestorePlanWithChan invokes the hbase.CreateRestorePlan API asynchronously
func (client *Client) CreateRestorePlanWithChan(request *CreateRestorePlanRequest) (<-chan *CreateRestorePlanResponse, <-chan error) {
	responseChan := make(chan *CreateRestorePlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRestorePlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRestorePlanWithCallback invokes the hbase.CreateRestorePlan API asynchronously
func (client *Client) CreateRestorePlanWithCallback(request *CreateRestorePlanRequest, callback func(response *CreateRestorePlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRestorePlanResponse
		var err error
		defer close(result)
		response, err = client.CreateRestorePlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRestorePlanRequest is the request struct for api CreateRestorePlan
type CreateRestorePlanRequest struct {
	*requests.RpcRequest
	RestoreToDate   string           `position:"Query" name:"RestoreToDate"`
	Tables          string           `position:"Query" name:"Tables"`
	RestoreByCopy   requests.Boolean `position:"Query" name:"RestoreByCopy"`
	RestoreAllTable requests.Boolean `position:"Query" name:"RestoreAllTable"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	TargetClusterId string           `position:"Query" name:"TargetClusterId"`
}

// CreateRestorePlanResponse is the response struct for api CreateRestorePlan
type CreateRestorePlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateRestorePlanRequest creates a request to invoke CreateRestorePlan API
func CreateCreateRestorePlanRequest() (request *CreateRestorePlanRequest) {
	request = &CreateRestorePlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "CreateRestorePlan", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateRestorePlanResponse creates a response to parse from CreateRestorePlan response
func CreateCreateRestorePlanResponse() (response *CreateRestorePlanResponse) {
	response = &CreateRestorePlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
