package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceDiagnosisSummary invokes the gpdb.DescribeDBInstanceDiagnosisSummary API synchronously
func (client *Client) DescribeDBInstanceDiagnosisSummary(request *DescribeDBInstanceDiagnosisSummaryRequest) (response *DescribeDBInstanceDiagnosisSummaryResponse, err error) {
	response = CreateDescribeDBInstanceDiagnosisSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceDiagnosisSummaryWithChan invokes the gpdb.DescribeDBInstanceDiagnosisSummary API asynchronously
func (client *Client) DescribeDBInstanceDiagnosisSummaryWithChan(request *DescribeDBInstanceDiagnosisSummaryRequest) (<-chan *DescribeDBInstanceDiagnosisSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceDiagnosisSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceDiagnosisSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceDiagnosisSummaryWithCallback invokes the gpdb.DescribeDBInstanceDiagnosisSummary API asynchronously
func (client *Client) DescribeDBInstanceDiagnosisSummaryWithCallback(request *DescribeDBInstanceDiagnosisSummaryRequest, callback func(response *DescribeDBInstanceDiagnosisSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceDiagnosisSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceDiagnosisSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceDiagnosisSummaryRequest is the request struct for api DescribeDBInstanceDiagnosisSummary
type DescribeDBInstanceDiagnosisSummaryRequest struct {
	*requests.RpcRequest
	StartStatus  string           `position:"Query" name:"StartStatus"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	SyncMode     string           `position:"Query" name:"SyncMode"`
	RolePreferd  string           `position:"Query" name:"RolePreferd"`
}

// DescribeDBInstanceDiagnosisSummaryResponse is the response struct for api DescribeDBInstanceDiagnosisSummary
type DescribeDBInstanceDiagnosisSummaryResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TotalCount        string            `json:"TotalCount" xml:"TotalCount"`
	PageNumber        string            `json:"PageNumber" xml:"PageNumber"`
	MasterStatusInfo  MasterStatusInfo  `json:"MasterStatusInfo" xml:"MasterStatusInfo"`
	SegmentStatusInfo SegmentStatusInfo `json:"SegmentStatusInfo" xml:"SegmentStatusInfo"`
	Items             []ItemsItem       `json:"Items" xml:"Items"`
}

// CreateDescribeDBInstanceDiagnosisSummaryRequest creates a request to invoke DescribeDBInstanceDiagnosisSummary API
func CreateDescribeDBInstanceDiagnosisSummaryRequest() (request *DescribeDBInstanceDiagnosisSummaryRequest) {
	request = &DescribeDBInstanceDiagnosisSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDBInstanceDiagnosisSummary", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceDiagnosisSummaryResponse creates a response to parse from DescribeDBInstanceDiagnosisSummary response
func CreateDescribeDBInstanceDiagnosisSummaryResponse() (response *DescribeDBInstanceDiagnosisSummaryResponse) {
	response = &DescribeDBInstanceDiagnosisSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
