package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchEnrollAccounts invokes the governance.BatchEnrollAccounts API synchronously
func (client *Client) BatchEnrollAccounts(request *BatchEnrollAccountsRequest) (response *BatchEnrollAccountsResponse, err error) {
	response = CreateBatchEnrollAccountsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchEnrollAccountsWithChan invokes the governance.BatchEnrollAccounts API asynchronously
func (client *Client) BatchEnrollAccountsWithChan(request *BatchEnrollAccountsRequest) (<-chan *BatchEnrollAccountsResponse, <-chan error) {
	responseChan := make(chan *BatchEnrollAccountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchEnrollAccounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchEnrollAccountsWithCallback invokes the governance.BatchEnrollAccounts API asynchronously
func (client *Client) BatchEnrollAccountsWithCallback(request *BatchEnrollAccountsRequest, callback func(response *BatchEnrollAccountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchEnrollAccountsResponse
		var err error
		defer close(result)
		response, err = client.BatchEnrollAccounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchEnrollAccountsRequest is the request struct for api BatchEnrollAccounts
type BatchEnrollAccountsRequest struct {
	*requests.RpcRequest
	BaselineId    string                              `position:"Query" name:"BaselineId"`
	BaselineItems *[]BatchEnrollAccountsBaselineItems `position:"Query" name:"BaselineItems"  type:"Repeated"`
	Accounts      *[]BatchEnrollAccountsAccounts      `position:"Query" name:"Accounts"  type:"Repeated"`
}

// BatchEnrollAccountsBaselineItems is a repeated param struct in BatchEnrollAccountsRequest
type BatchEnrollAccountsBaselineItems struct {
	Name    string `name:"Name"`
	Skip    string `name:"Skip"`
	Config  string `name:"Config"`
	Version string `name:"Version"`
}

// BatchEnrollAccountsAccounts is a repeated param struct in BatchEnrollAccountsRequest
type BatchEnrollAccountsAccounts struct {
	AccountUid string `name:"AccountUid"`
}

// BatchEnrollAccountsResponse is the response struct for api BatchEnrollAccounts
type BatchEnrollAccountsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchEnrollAccountsRequest creates a request to invoke BatchEnrollAccounts API
func CreateBatchEnrollAccountsRequest() (request *BatchEnrollAccountsRequest) {
	request = &BatchEnrollAccountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "BatchEnrollAccounts", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchEnrollAccountsResponse creates a response to parse from BatchEnrollAccounts response
func CreateBatchEnrollAccountsResponse() (response *BatchEnrollAccountsResponse) {
	response = &BatchEnrollAccountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
