package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceExceptions invokes the foas.GetInstanceExceptions API synchronously
func (client *Client) GetInstanceExceptions(request *GetInstanceExceptionsRequest) (response *GetInstanceExceptionsResponse, err error) {
	response = CreateGetInstanceExceptionsResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceExceptionsWithChan invokes the foas.GetInstanceExceptions API asynchronously
func (client *Client) GetInstanceExceptionsWithChan(request *GetInstanceExceptionsRequest) (<-chan *GetInstanceExceptionsResponse, <-chan error) {
	responseChan := make(chan *GetInstanceExceptionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceExceptions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceExceptionsWithCallback invokes the foas.GetInstanceExceptions API asynchronously
func (client *Client) GetInstanceExceptionsWithCallback(request *GetInstanceExceptionsRequest, callback func(response *GetInstanceExceptionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceExceptionsResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceExceptions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceExceptionsRequest is the request struct for api GetInstanceExceptions
type GetInstanceExceptionsRequest struct {
	*requests.RoaRequest
	ProjectName string           `position:"Path" name:"projectName"`
	InstanceId  requests.Integer `position:"Path" name:"instanceId"`
	JobName     string           `position:"Path" name:"jobName"`
}

// GetInstanceExceptionsResponse is the response struct for api GetInstanceExceptions
type GetInstanceExceptionsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Exceptions string `json:"Exceptions" xml:"Exceptions"`
}

// CreateGetInstanceExceptionsRequest creates a request to invoke GetInstanceExceptions API
func CreateGetInstanceExceptionsRequest() (request *GetInstanceExceptionsRequest) {
	request = &GetInstanceExceptionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetInstanceExceptions", "/api/v2/projects/[projectName]/jobs/[jobName]/instances/[instanceId]/exceptions", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetInstanceExceptionsResponse creates a response to parse from GetInstanceExceptions response
func CreateGetInstanceExceptionsResponse() (response *GetInstanceExceptionsResponse) {
	response = &GetInstanceExceptionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
