package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachInstanceSDG invokes the ens.DetachInstanceSDG API synchronously
func (client *Client) DetachInstanceSDG(request *DetachInstanceSDGRequest) (response *DetachInstanceSDGResponse, err error) {
	response = CreateDetachInstanceSDGResponse()
	err = client.DoAction(request, response)
	return
}

// DetachInstanceSDGWithChan invokes the ens.DetachInstanceSDG API asynchronously
func (client *Client) DetachInstanceSDGWithChan(request *DetachInstanceSDGRequest) (<-chan *DetachInstanceSDGResponse, <-chan error) {
	responseChan := make(chan *DetachInstanceSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachInstanceSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachInstanceSDGWithCallback invokes the ens.DetachInstanceSDG API asynchronously
func (client *Client) DetachInstanceSDGWithCallback(request *DetachInstanceSDGRequest, callback func(response *DetachInstanceSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachInstanceSDGResponse
		var err error
		defer close(result)
		response, err = client.DetachInstanceSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachInstanceSDGRequest is the request struct for api DetachInstanceSDG
type DetachInstanceSDGRequest struct {
	*requests.RpcRequest
	SDGId       string    `position:"Query" name:"SDGId"`
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Json"`
}

// DetachInstanceSDGResponse is the response struct for api DetachInstanceSDG
type DetachInstanceSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetachInstanceSDGRequest creates a request to invoke DetachInstanceSDG API
func CreateDetachInstanceSDGRequest() (request *DetachInstanceSDGRequest) {
	request = &DetachInstanceSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DetachInstanceSDG", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachInstanceSDGResponse creates a response to parse from DetachInstanceSDG response
func CreateDetachInstanceSDGResponse() (response *DetachInstanceSDGResponse) {
	response = &DetachInstanceSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
