package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudDiskAvailableResourceInfo invokes the ens.DescribeCloudDiskAvailableResourceInfo API synchronously
func (client *Client) DescribeCloudDiskAvailableResourceInfo(request *DescribeCloudDiskAvailableResourceInfoRequest) (response *DescribeCloudDiskAvailableResourceInfoResponse, err error) {
	response = CreateDescribeCloudDiskAvailableResourceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudDiskAvailableResourceInfoWithChan invokes the ens.DescribeCloudDiskAvailableResourceInfo API asynchronously
func (client *Client) DescribeCloudDiskAvailableResourceInfoWithChan(request *DescribeCloudDiskAvailableResourceInfoRequest) (<-chan *DescribeCloudDiskAvailableResourceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudDiskAvailableResourceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudDiskAvailableResourceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudDiskAvailableResourceInfoWithCallback invokes the ens.DescribeCloudDiskAvailableResourceInfo API asynchronously
func (client *Client) DescribeCloudDiskAvailableResourceInfoWithCallback(request *DescribeCloudDiskAvailableResourceInfoRequest, callback func(response *DescribeCloudDiskAvailableResourceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudDiskAvailableResourceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudDiskAvailableResourceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudDiskAvailableResourceInfoRequest is the request struct for api DescribeCloudDiskAvailableResourceInfo
type DescribeCloudDiskAvailableResourceInfoRequest struct {
	*requests.RpcRequest
}

// DescribeCloudDiskAvailableResourceInfoResponse is the response struct for api DescribeCloudDiskAvailableResourceInfo
type DescribeCloudDiskAvailableResourceInfoResponse struct {
	*responses.BaseResponse
	RequestId        string                                                   `json:"RequestId" xml:"RequestId"`
	SupportResources SupportResourcesInDescribeCloudDiskAvailableResourceInfo `json:"SupportResources" xml:"SupportResources"`
}

// CreateDescribeCloudDiskAvailableResourceInfoRequest creates a request to invoke DescribeCloudDiskAvailableResourceInfo API
func CreateDescribeCloudDiskAvailableResourceInfoRequest() (request *DescribeCloudDiskAvailableResourceInfoRequest) {
	request = &DescribeCloudDiskAvailableResourceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeCloudDiskAvailableResourceInfo", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeCloudDiskAvailableResourceInfoResponse creates a response to parse from DescribeCloudDiskAvailableResourceInfo response
func CreateDescribeCloudDiskAvailableResourceInfoResponse() (response *DescribeCloudDiskAvailableResourceInfoResponse) {
	response = &DescribeCloudDiskAvailableResourceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
