package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListKibanaPvlNetwork invokes the elasticsearch.ListKibanaPvlNetwork API synchronously
func (client *Client) ListKibanaPvlNetwork(request *ListKibanaPvlNetworkRequest) (response *ListKibanaPvlNetworkResponse, err error) {
	response = CreateListKibanaPvlNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// ListKibanaPvlNetworkWithChan invokes the elasticsearch.ListKibanaPvlNetwork API asynchronously
func (client *Client) ListKibanaPvlNetworkWithChan(request *ListKibanaPvlNetworkRequest) (<-chan *ListKibanaPvlNetworkResponse, <-chan error) {
	responseChan := make(chan *ListKibanaPvlNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListKibanaPvlNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListKibanaPvlNetworkWithCallback invokes the elasticsearch.ListKibanaPvlNetwork API asynchronously
func (client *Client) ListKibanaPvlNetworkWithCallback(request *ListKibanaPvlNetworkRequest, callback func(response *ListKibanaPvlNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListKibanaPvlNetworkResponse
		var err error
		defer close(result)
		response, err = client.ListKibanaPvlNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListKibanaPvlNetworkRequest is the request struct for api ListKibanaPvlNetwork
type ListKibanaPvlNetworkRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListKibanaPvlNetworkResponse is the response struct for api ListKibanaPvlNetwork
type ListKibanaPvlNetworkResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListKibanaPvlNetworkRequest creates a request to invoke ListKibanaPvlNetwork API
func CreateListKibanaPvlNetworkRequest() (request *ListKibanaPvlNetworkRequest) {
	request = &ListKibanaPvlNetworkRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListKibanaPvlNetwork", "/openapi/instances/[InstanceId]/actions/get-kibana-private", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListKibanaPvlNetworkResponse creates a response to parse from ListKibanaPvlNetwork response
func CreateListKibanaPvlNetworkResponse() (response *ListKibanaPvlNetworkResponse) {
	response = &ListKibanaPvlNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
