package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeactivateZones invokes the elasticsearch.DeactivateZones API synchronously
func (client *Client) DeactivateZones(request *DeactivateZonesRequest) (response *DeactivateZonesResponse, err error) {
	response = CreateDeactivateZonesResponse()
	err = client.DoAction(request, response)
	return
}

// DeactivateZonesWithChan invokes the elasticsearch.DeactivateZones API asynchronously
func (client *Client) DeactivateZonesWithChan(request *DeactivateZonesRequest) (<-chan *DeactivateZonesResponse, <-chan error) {
	responseChan := make(chan *DeactivateZonesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeactivateZones(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeactivateZonesWithCallback invokes the elasticsearch.DeactivateZones API asynchronously
func (client *Client) DeactivateZonesWithCallback(request *DeactivateZonesRequest, callback func(response *DeactivateZonesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeactivateZonesResponse
		var err error
		defer close(result)
		response, err = client.DeactivateZones(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeactivateZonesRequest is the request struct for api DeactivateZones
type DeactivateZonesRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
	Body        string `position:"Body" name:"body"`
}

// DeactivateZonesResponse is the response struct for api DeactivateZones
type DeactivateZonesResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeactivateZonesRequest creates a request to invoke DeactivateZones API
func CreateDeactivateZonesRequest() (request *DeactivateZonesRequest) {
	request = &DeactivateZonesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DeactivateZones", "/openapi/instances/[InstanceId]/actions/down-zones", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeactivateZonesResponse creates a response to parse from DeactivateZones response
func CreateDeactivateZonesResponse() (response *DeactivateZonesResponse) {
	response = &DeactivateZonesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
