package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDirectorySsoStatus invokes the ecd.SetDirectorySsoStatus API synchronously
func (client *Client) SetDirectorySsoStatus(request *SetDirectorySsoStatusRequest) (response *SetDirectorySsoStatusResponse, err error) {
	response = CreateSetDirectorySsoStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetDirectorySsoStatusWithChan invokes the ecd.SetDirectorySsoStatus API asynchronously
func (client *Client) SetDirectorySsoStatusWithChan(request *SetDirectorySsoStatusRequest) (<-chan *SetDirectorySsoStatusResponse, <-chan error) {
	responseChan := make(chan *SetDirectorySsoStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDirectorySsoStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDirectorySsoStatusWithCallback invokes the ecd.SetDirectorySsoStatus API asynchronously
func (client *Client) SetDirectorySsoStatusWithCallback(request *SetDirectorySsoStatusRequest, callback func(response *SetDirectorySsoStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDirectorySsoStatusResponse
		var err error
		defer close(result)
		response, err = client.SetDirectorySsoStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDirectorySsoStatusRequest is the request struct for api SetDirectorySsoStatus
type SetDirectorySsoStatusRequest struct {
	*requests.RpcRequest
	EnableSso   requests.Boolean `position:"Query" name:"EnableSso"`
	DirectoryId string           `position:"Query" name:"DirectoryId"`
}

// SetDirectorySsoStatusResponse is the response struct for api SetDirectorySsoStatus
type SetDirectorySsoStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDirectorySsoStatusRequest creates a request to invoke SetDirectorySsoStatus API
func CreateSetDirectorySsoStatusRequest() (request *SetDirectorySsoStatusRequest) {
	request = &SetDirectorySsoStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "SetDirectorySsoStatus", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDirectorySsoStatusResponse creates a response to parse from SetDirectorySsoStatus response
func CreateSetDirectorySsoStatusResponse() (response *SetDirectorySsoStatusResponse) {
	response = &SetDirectorySsoStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
