package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDedicatedBlockStorageCluster invokes the ebs.CreateDedicatedBlockStorageCluster API synchronously
func (client *Client) CreateDedicatedBlockStorageCluster(request *CreateDedicatedBlockStorageClusterRequest) (response *CreateDedicatedBlockStorageClusterResponse, err error) {
	response = CreateCreateDedicatedBlockStorageClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDedicatedBlockStorageClusterWithChan invokes the ebs.CreateDedicatedBlockStorageCluster API asynchronously
func (client *Client) CreateDedicatedBlockStorageClusterWithChan(request *CreateDedicatedBlockStorageClusterRequest) (<-chan *CreateDedicatedBlockStorageClusterResponse, <-chan error) {
	responseChan := make(chan *CreateDedicatedBlockStorageClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDedicatedBlockStorageCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDedicatedBlockStorageClusterWithCallback invokes the ebs.CreateDedicatedBlockStorageCluster API asynchronously
func (client *Client) CreateDedicatedBlockStorageClusterWithCallback(request *CreateDedicatedBlockStorageClusterRequest, callback func(response *CreateDedicatedBlockStorageClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDedicatedBlockStorageClusterResponse
		var err error
		defer close(result)
		response, err = client.CreateDedicatedBlockStorageCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDedicatedBlockStorageClusterRequest is the request struct for api CreateDedicatedBlockStorageCluster
type CreateDedicatedBlockStorageClusterRequest struct {
	*requests.RpcRequest
	Type            string                                   `position:"Query" name:"Type"`
	Capacity        requests.Integer                         `position:"Query" name:"Capacity"`
	ResourceGroupId string                                   `position:"Query" name:"ResourceGroupId"`
	DbscId          string                                   `position:"Query" name:"DbscId"`
	Tag             *[]CreateDedicatedBlockStorageClusterTag `position:"Query" name:"Tag"  type:"Repeated"`
	Azone           string                                   `position:"Query" name:"Azone"`
	Period          requests.Integer                         `position:"Query" name:"Period"`
	DbscName        string                                   `position:"Query" name:"DbscName"`
	PeriodUnit      string                                   `position:"Query" name:"PeriodUnit"`
}

// CreateDedicatedBlockStorageClusterTag is a repeated param struct in CreateDedicatedBlockStorageClusterRequest
type CreateDedicatedBlockStorageClusterTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateDedicatedBlockStorageClusterResponse is the response struct for api CreateDedicatedBlockStorageCluster
type CreateDedicatedBlockStorageClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
	DbscId    string `json:"DbscId" xml:"DbscId"`
}

// CreateCreateDedicatedBlockStorageClusterRequest creates a request to invoke CreateDedicatedBlockStorageCluster API
func CreateCreateDedicatedBlockStorageClusterRequest() (request *CreateDedicatedBlockStorageClusterRequest) {
	request = &CreateDedicatedBlockStorageClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "CreateDedicatedBlockStorageCluster", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDedicatedBlockStorageClusterResponse creates a response to parse from CreateDedicatedBlockStorageCluster response
func CreateCreateDedicatedBlockStorageClusterResponse() (response *CreateDedicatedBlockStorageClusterResponse) {
	response = &CreateDedicatedBlockStorageClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
