package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddVirtualNumberRelation invokes the dyvmsapi.AddVirtualNumberRelation API synchronously
func (client *Client) AddVirtualNumberRelation(request *AddVirtualNumberRelationRequest) (response *AddVirtualNumberRelationResponse, err error) {
	response = CreateAddVirtualNumberRelationResponse()
	err = client.DoAction(request, response)
	return
}

// AddVirtualNumberRelationWithChan invokes the dyvmsapi.AddVirtualNumberRelation API asynchronously
func (client *Client) AddVirtualNumberRelationWithChan(request *AddVirtualNumberRelationRequest) (<-chan *AddVirtualNumberRelationResponse, <-chan error) {
	responseChan := make(chan *AddVirtualNumberRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddVirtualNumberRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddVirtualNumberRelationWithCallback invokes the dyvmsapi.AddVirtualNumberRelation API asynchronously
func (client *Client) AddVirtualNumberRelationWithCallback(request *AddVirtualNumberRelationRequest, callback func(response *AddVirtualNumberRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddVirtualNumberRelationResponse
		var err error
		defer close(result)
		response, err = client.AddVirtualNumberRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddVirtualNumberRelationRequest is the request struct for api AddVirtualNumberRelation
type AddVirtualNumberRelationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NumberList           string           `position:"Query" name:"NumberList"`
	RouteType            requests.Integer `position:"Query" name:"RouteType"`
	CorpNameList         string           `position:"Query" name:"CorpNameList"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	PhoneNum             string           `position:"Query" name:"PhoneNum"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// AddVirtualNumberRelationResponse is the response struct for api AddVirtualNumberRelation
type AddVirtualNumberRelationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateAddVirtualNumberRelationRequest creates a request to invoke AddVirtualNumberRelation API
func CreateAddVirtualNumberRelationRequest() (request *AddVirtualNumberRelationRequest) {
	request = &AddVirtualNumberRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "AddVirtualNumberRelation", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddVirtualNumberRelationResponse creates a response to parse from AddVirtualNumberRelation response
func CreateAddVirtualNumberRelationResponse() (response *AddVirtualNumberRelationResponse) {
	response = &AddVirtualNumberRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
