package dt_oc_info

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOcIcBasic invokes the dt_oc_info.GetOcIcBasic API synchronously
func (client *Client) GetOcIcBasic(request *GetOcIcBasicRequest) (response *GetOcIcBasicResponse, err error) {
	response = CreateGetOcIcBasicResponse()
	err = client.DoAction(request, response)
	return
}

// GetOcIcBasicWithChan invokes the dt_oc_info.GetOcIcBasic API asynchronously
func (client *Client) GetOcIcBasicWithChan(request *GetOcIcBasicRequest) (<-chan *GetOcIcBasicResponse, <-chan error) {
	responseChan := make(chan *GetOcIcBasicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOcIcBasic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOcIcBasicWithCallback invokes the dt_oc_info.GetOcIcBasic API asynchronously
func (client *Client) GetOcIcBasicWithCallback(request *GetOcIcBasicRequest, callback func(response *GetOcIcBasicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOcIcBasicResponse
		var err error
		defer close(result)
		response, err = client.GetOcIcBasic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOcIcBasicRequest is the request struct for api GetOcIcBasic
type GetOcIcBasicRequest struct {
	*requests.RpcRequest
	SearchKey string `position:"Body" name:"SearchKey"`
}

// GetOcIcBasicResponse is the response struct for api GetOcIcBasic
type GetOcIcBasicResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	TotalNum  int    `json:"TotalNum" xml:"TotalNum"`
	PageIndex int    `json:"PageIndex" xml:"PageIndex"`
	PageNum   int    `json:"PageNum" xml:"PageNum"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetOcIcBasicRequest creates a request to invoke GetOcIcBasic API
func CreateGetOcIcBasicRequest() (request *GetOcIcBasicRequest) {
	request = &GetOcIcBasicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dt-oc-info", "2022-08-29", "GetOcIcBasic", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOcIcBasicResponse creates a response to parse from GetOcIcBasic response
func CreateGetOcIcBasicResponse() (response *GetOcIcBasicResponse) {
	response = &GetOcIcBasicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
