package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveDataExportJob invokes the dms_enterprise.RemoveDataExportJob API synchronously
func (client *Client) RemoveDataExportJob(request *RemoveDataExportJobRequest) (response *RemoveDataExportJobResponse, err error) {
	response = CreateRemoveDataExportJobResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveDataExportJobWithChan invokes the dms_enterprise.RemoveDataExportJob API asynchronously
func (client *Client) RemoveDataExportJobWithChan(request *RemoveDataExportJobRequest) (<-chan *RemoveDataExportJobResponse, <-chan error) {
	responseChan := make(chan *RemoveDataExportJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveDataExportJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveDataExportJobWithCallback invokes the dms_enterprise.RemoveDataExportJob API asynchronously
func (client *Client) RemoveDataExportJobWithCallback(request *RemoveDataExportJobRequest, callback func(response *RemoveDataExportJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveDataExportJobResponse
		var err error
		defer close(result)
		response, err = client.RemoveDataExportJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveDataExportJobRequest is the request struct for api RemoveDataExportJob
type RemoveDataExportJobRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	JobId   requests.Integer `position:"Query" name:"JobId"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// RemoveDataExportJobResponse is the response struct for api RemoveDataExportJob
type RemoveDataExportJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateRemoveDataExportJobRequest creates a request to invoke RemoveDataExportJob API
func CreateRemoveDataExportJobRequest() (request *RemoveDataExportJobRequest) {
	request = &RemoveDataExportJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "RemoveDataExportJob", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveDataExportJobResponse creates a response to parse from RemoveDataExportJob response
func CreateRemoveDataExportJobResponse() (response *RemoveDataExportJobResponse) {
	response = &RemoveDataExportJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
