package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAuthorityTemplateItem invokes the dms_enterprise.GetAuthorityTemplateItem API synchronously
func (client *Client) GetAuthorityTemplateItem(request *GetAuthorityTemplateItemRequest) (response *GetAuthorityTemplateItemResponse, err error) {
	response = CreateGetAuthorityTemplateItemResponse()
	err = client.DoAction(request, response)
	return
}

// GetAuthorityTemplateItemWithChan invokes the dms_enterprise.GetAuthorityTemplateItem API asynchronously
func (client *Client) GetAuthorityTemplateItemWithChan(request *GetAuthorityTemplateItemRequest) (<-chan *GetAuthorityTemplateItemResponse, <-chan error) {
	responseChan := make(chan *GetAuthorityTemplateItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAuthorityTemplateItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAuthorityTemplateItemWithCallback invokes the dms_enterprise.GetAuthorityTemplateItem API asynchronously
func (client *Client) GetAuthorityTemplateItemWithCallback(request *GetAuthorityTemplateItemRequest, callback func(response *GetAuthorityTemplateItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAuthorityTemplateItemResponse
		var err error
		defer close(result)
		response, err = client.GetAuthorityTemplateItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAuthorityTemplateItemRequest is the request struct for api GetAuthorityTemplateItem
type GetAuthorityTemplateItemRequest struct {
	*requests.RpcRequest
	Tid        requests.Integer `position:"Query" name:"Tid"`
	TemplateId requests.Integer `position:"Query" name:"TemplateId"`
}

// GetAuthorityTemplateItemResponse is the response struct for api GetAuthorityTemplateItem
type GetAuthorityTemplateItemResponse struct {
	*responses.BaseResponse
	RequestId                 string                                              `json:"RequestId" xml:"RequestId"`
	ErrorCode                 string                                              `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage              string                                              `json:"ErrorMessage" xml:"ErrorMessage"`
	Success                   bool                                                `json:"Success" xml:"Success"`
	Tid                       int64                                               `json:"Tid" xml:"Tid"`
	AuthorityTemplateItemList AuthorityTemplateItemListInGetAuthorityTemplateItem `json:"AuthorityTemplateItemList" xml:"AuthorityTemplateItemList"`
}

// CreateGetAuthorityTemplateItemRequest creates a request to invoke GetAuthorityTemplateItem API
func CreateGetAuthorityTemplateItemRequest() (request *GetAuthorityTemplateItemRequest) {
	request = &GetAuthorityTemplateItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetAuthorityTemplateItem", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAuthorityTemplateItemResponse creates a response to parse from GetAuthorityTemplateItem response
func CreateGetAuthorityTemplateItemResponse() (response *GetAuthorityTemplateItemResponse) {
	response = &GetAuthorityTemplateItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
