package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPipelineLog invokes the devops_rdc.GetPipelineLog API synchronously
func (client *Client) GetPipelineLog(request *GetPipelineLogRequest) (response *GetPipelineLogResponse, err error) {
	response = CreateGetPipelineLogResponse()
	err = client.DoAction(request, response)
	return
}

// GetPipelineLogWithChan invokes the devops_rdc.GetPipelineLog API asynchronously
func (client *Client) GetPipelineLogWithChan(request *GetPipelineLogRequest) (<-chan *GetPipelineLogResponse, <-chan error) {
	responseChan := make(chan *GetPipelineLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPipelineLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPipelineLogWithCallback invokes the devops_rdc.GetPipelineLog API asynchronously
func (client *Client) GetPipelineLogWithCallback(request *GetPipelineLogRequest, callback func(response *GetPipelineLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPipelineLogResponse
		var err error
		defer close(result)
		response, err = client.GetPipelineLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPipelineLogRequest is the request struct for api GetPipelineLog
type GetPipelineLogRequest struct {
	*requests.RpcRequest
	UserPk     string           `position:"Body" name:"UserPk"`
	OrgId      string           `position:"Body" name:"OrgId"`
	PipelineId requests.Integer `position:"Body" name:"PipelineId"`
	JobId      requests.Integer `position:"Body" name:"JobId"`
}

// GetPipelineLogResponse is the response struct for api GetPipelineLog
type GetPipelineLogResponse struct {
	*responses.BaseResponse
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Object       []Job  `json:"Object" xml:"Object"`
}

// CreateGetPipelineLogRequest creates a request to invoke GetPipelineLog API
func CreateGetPipelineLogRequest() (request *GetPipelineLogRequest) {
	request = &GetPipelineLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "GetPipelineLog", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPipelineLogResponse creates a response to parse from GetPipelineLog response
func CreateGetPipelineLogResponse() (response *GetPipelineLogResponse) {
	response = &GetPipelineLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
