package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchSchedulerRule invokes the ddoscoo.SwitchSchedulerRule API synchronously
func (client *Client) SwitchSchedulerRule(request *SwitchSchedulerRuleRequest) (response *SwitchSchedulerRuleResponse, err error) {
	response = CreateSwitchSchedulerRuleResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchSchedulerRuleWithChan invokes the ddoscoo.SwitchSchedulerRule API asynchronously
func (client *Client) SwitchSchedulerRuleWithChan(request *SwitchSchedulerRuleRequest) (<-chan *SwitchSchedulerRuleResponse, <-chan error) {
	responseChan := make(chan *SwitchSchedulerRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchSchedulerRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchSchedulerRuleWithCallback invokes the ddoscoo.SwitchSchedulerRule API asynchronously
func (client *Client) SwitchSchedulerRuleWithCallback(request *SwitchSchedulerRuleRequest, callback func(response *SwitchSchedulerRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchSchedulerRuleResponse
		var err error
		defer close(result)
		response, err = client.SwitchSchedulerRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchSchedulerRuleRequest is the request struct for api SwitchSchedulerRule
type SwitchSchedulerRuleRequest struct {
	*requests.RpcRequest
	RuleType   requests.Integer `position:"Query" name:"RuleType"`
	RuleName   string           `position:"Query" name:"RuleName"`
	SwitchData string           `position:"Query" name:"SwitchData"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
}

// SwitchSchedulerRuleResponse is the response struct for api SwitchSchedulerRule
type SwitchSchedulerRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSwitchSchedulerRuleRequest creates a request to invoke SwitchSchedulerRule API
func CreateSwitchSchedulerRuleRequest() (request *SwitchSchedulerRuleRequest) {
	request = &SwitchSchedulerRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "SwitchSchedulerRule", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchSchedulerRuleResponse creates a response to parse from SwitchSchedulerRule response
func CreateSwitchSchedulerRuleResponse() (response *SwitchSchedulerRuleResponse) {
	response = &SwitchSchedulerRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
