package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeElasticQpsRecord invokes the ddoscoo.DescribeElasticQpsRecord API synchronously
func (client *Client) DescribeElasticQpsRecord(request *DescribeElasticQpsRecordRequest) (response *DescribeElasticQpsRecordResponse, err error) {
	response = CreateDescribeElasticQpsRecordResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeElasticQpsRecordWithChan invokes the ddoscoo.DescribeElasticQpsRecord API asynchronously
func (client *Client) DescribeElasticQpsRecordWithChan(request *DescribeElasticQpsRecordRequest) (<-chan *DescribeElasticQpsRecordResponse, <-chan error) {
	responseChan := make(chan *DescribeElasticQpsRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeElasticQpsRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeElasticQpsRecordWithCallback invokes the ddoscoo.DescribeElasticQpsRecord API asynchronously
func (client *Client) DescribeElasticQpsRecordWithCallback(request *DescribeElasticQpsRecordRequest, callback func(response *DescribeElasticQpsRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeElasticQpsRecordResponse
		var err error
		defer close(result)
		response, err = client.DescribeElasticQpsRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeElasticQpsRecordRequest is the request struct for api DescribeElasticQpsRecord
type DescribeElasticQpsRecordRequest struct {
	*requests.RpcRequest
	Ip        string           `position:"Query" name:"Ip"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
}

// DescribeElasticQpsRecordResponse is the response struct for api DescribeElasticQpsRecord
type DescribeElasticQpsRecordResponse struct {
	*responses.BaseResponse
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	ElasticQpsList []ElasticQpsListItem `json:"ElasticQpsList" xml:"ElasticQpsList"`
}

// CreateDescribeElasticQpsRecordRequest creates a request to invoke DescribeElasticQpsRecord API
func CreateDescribeElasticQpsRecordRequest() (request *DescribeElasticQpsRecordRequest) {
	request = &DescribeElasticQpsRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeElasticQpsRecord", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeElasticQpsRecordResponse creates a response to parse from DescribeElasticQpsRecord response
func CreateDescribeElasticQpsRecordResponse() (response *DescribeElasticQpsRecordResponse) {
	response = &DescribeElasticQpsRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
