package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWebRule invokes the ddoscoo.DeleteWebRule API synchronously
func (client *Client) DeleteWebRule(request *DeleteWebRuleRequest) (response *DeleteWebRuleResponse, err error) {
	response = CreateDeleteWebRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWebRuleWithChan invokes the ddoscoo.DeleteWebRule API asynchronously
func (client *Client) DeleteWebRuleWithChan(request *DeleteWebRuleRequest) (<-chan *DeleteWebRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteWebRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWebRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWebRuleWithCallback invokes the ddoscoo.DeleteWebRule API asynchronously
func (client *Client) DeleteWebRuleWithCallback(request *DeleteWebRuleRequest, callback func(response *DeleteWebRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWebRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteWebRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWebRuleRequest is the request struct for api DeleteWebRule
type DeleteWebRuleRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
}

// DeleteWebRuleResponse is the response struct for api DeleteWebRule
type DeleteWebRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteWebRuleRequest creates a request to invoke DeleteWebRule API
func CreateDeleteWebRuleRequest() (request *DeleteWebRuleRequest) {
	request = &DeleteWebRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DeleteWebRule", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteWebRuleResponse creates a response to parse from DeleteWebRule response
func CreateDeleteWebRuleResponse() (response *DeleteWebRuleResponse) {
	response = &DeleteWebRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
