package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDbfs invokes the dbfs.UpdateDbfs API synchronously
func (client *Client) UpdateDbfs(request *UpdateDbfsRequest) (response *UpdateDbfsResponse, err error) {
	response = CreateUpdateDbfsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDbfsWithChan invokes the dbfs.UpdateDbfs API asynchronously
func (client *Client) UpdateDbfsWithChan(request *UpdateDbfsRequest) (<-chan *UpdateDbfsResponse, <-chan error) {
	responseChan := make(chan *UpdateDbfsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDbfs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDbfsWithCallback invokes the dbfs.UpdateDbfs API asynchronously
func (client *Client) UpdateDbfsWithCallback(request *UpdateDbfsRequest, callback func(response *UpdateDbfsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDbfsResponse
		var err error
		defer close(result)
		response, err = client.UpdateDbfs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDbfsRequest is the request struct for api UpdateDbfs
type UpdateDbfsRequest struct {
	*requests.RpcRequest
	UsedScene        string `position:"Query" name:"UsedScene"`
	FsId             string `position:"Query" name:"FsId"`
	InstanceType     string `position:"Query" name:"InstanceType"`
	AdvancedFeatures string `position:"Query" name:"AdvancedFeatures"`
}

// UpdateDbfsResponse is the response struct for api UpdateDbfs
type UpdateDbfsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDbfsRequest creates a request to invoke UpdateDbfs API
func CreateUpdateDbfsRequest() (request *UpdateDbfsRequest) {
	request = &UpdateDbfsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "UpdateDbfs", "dbfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDbfsResponse creates a response to parse from UpdateDbfs response
func CreateUpdateDbfsResponse() (response *UpdateDbfsResponse) {
	response = &UpdateDbfsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
