package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApDetailedStatus invokes the cloudwf.GetApDetailedStatus API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getapdetailedstatus.html
func (client *Client) GetApDetailedStatus(request *GetApDetailedStatusRequest) (response *GetApDetailedStatusResponse, err error) {
	response = CreateGetApDetailedStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetApDetailedStatusWithChan invokes the cloudwf.GetApDetailedStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapdetailedstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApDetailedStatusWithChan(request *GetApDetailedStatusRequest) (<-chan *GetApDetailedStatusResponse, <-chan error) {
	responseChan := make(chan *GetApDetailedStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApDetailedStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApDetailedStatusWithCallback invokes the cloudwf.GetApDetailedStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapdetailedstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApDetailedStatusWithCallback(request *GetApDetailedStatusRequest, callback func(response *GetApDetailedStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApDetailedStatusResponse
		var err error
		defer close(result)
		response, err = client.GetApDetailedStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApDetailedStatusRequest is the request struct for api GetApDetailedStatus
type GetApDetailedStatusRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// GetApDetailedStatusResponse is the response struct for api GetApDetailedStatus
type GetApDetailedStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetApDetailedStatusRequest creates a request to invoke GetApDetailedStatus API
func CreateGetApDetailedStatusRequest() (request *GetApDetailedStatusRequest) {
	request = &GetApDetailedStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetApDetailedStatus", "cloudwf", "openAPI")
	return
}

// CreateGetApDetailedStatusResponse creates a response to parse from GetApDetailedStatus response
func CreateGetApDetailedStatusResponse() (response *GetApDetailedStatusResponse) {
	response = &GetApDetailedStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
