package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInternetOpenIp invokes the cloudfw.DescribeInternetOpenIp API synchronously
func (client *Client) DescribeInternetOpenIp(request *DescribeInternetOpenIpRequest) (response *DescribeInternetOpenIpResponse, err error) {
	response = CreateDescribeInternetOpenIpResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInternetOpenIpWithChan invokes the cloudfw.DescribeInternetOpenIp API asynchronously
func (client *Client) DescribeInternetOpenIpWithChan(request *DescribeInternetOpenIpRequest) (<-chan *DescribeInternetOpenIpResponse, <-chan error) {
	responseChan := make(chan *DescribeInternetOpenIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInternetOpenIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInternetOpenIpWithCallback invokes the cloudfw.DescribeInternetOpenIp API asynchronously
func (client *Client) DescribeInternetOpenIpWithCallback(request *DescribeInternetOpenIpRequest, callback func(response *DescribeInternetOpenIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInternetOpenIpResponse
		var err error
		defer close(result)
		response, err = client.DescribeInternetOpenIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInternetOpenIpRequest is the request struct for api DescribeInternetOpenIp
type DescribeInternetOpenIpRequest struct {
	*requests.RpcRequest
	PublicIp           string `position:"Query" name:"PublicIp"`
	StartTime          string `position:"Query" name:"StartTime"`
	AssetsInstanceId   string `position:"Query" name:"AssetsInstanceId"`
	PageSize           string `position:"Query" name:"PageSize"`
	ServiceName        string `position:"Query" name:"ServiceName"`
	Lang               string `position:"Query" name:"Lang"`
	EndTime            string `position:"Query" name:"EndTime"`
	CurrentPage        string `position:"Query" name:"CurrentPage"`
	RiskLevel          string `position:"Query" name:"RiskLevel"`
	RegionNo           string `position:"Query" name:"RegionNo"`
	Port               string `position:"Query" name:"Port"`
	AssetsType         string `position:"Query" name:"AssetsType"`
	ServiceNameFuzzy   string `position:"Query" name:"ServiceNameFuzzy"`
	SuggestLevel       string `position:"Query" name:"SuggestLevel"`
	AssetsInstanceName string `position:"Query" name:"AssetsInstanceName"`
}

// DescribeInternetOpenIpResponse is the response struct for api DescribeInternetOpenIp
type DescribeInternetOpenIpResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo `json:"PageInfo" xml:"PageInfo"`
	DataList  []Data   `json:"DataList" xml:"DataList"`
}

// CreateDescribeInternetOpenIpRequest creates a request to invoke DescribeInternetOpenIp API
func CreateDescribeInternetOpenIpRequest() (request *DescribeInternetOpenIpRequest) {
	request = &DescribeInternetOpenIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeInternetOpenIp", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInternetOpenIpResponse creates a response to parse from DescribeInternetOpenIp response
func CreateDescribeInternetOpenIpResponse() (response *DescribeInternetOpenIpResponse) {
	response = &DescribeInternetOpenIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
