package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTrFirewallV2 invokes the cloudfw.DeleteTrFirewallV2 API synchronously
func (client *Client) DeleteTrFirewallV2(request *DeleteTrFirewallV2Request) (response *DeleteTrFirewallV2Response, err error) {
	response = CreateDeleteTrFirewallV2Response()
	err = client.DoAction(request, response)
	return
}

// DeleteTrFirewallV2WithChan invokes the cloudfw.DeleteTrFirewallV2 API asynchronously
func (client *Client) DeleteTrFirewallV2WithChan(request *DeleteTrFirewallV2Request) (<-chan *DeleteTrFirewallV2Response, <-chan error) {
	responseChan := make(chan *DeleteTrFirewallV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTrFirewallV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTrFirewallV2WithCallback invokes the cloudfw.DeleteTrFirewallV2 API asynchronously
func (client *Client) DeleteTrFirewallV2WithCallback(request *DeleteTrFirewallV2Request, callback func(response *DeleteTrFirewallV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTrFirewallV2Response
		var err error
		defer close(result)
		response, err = client.DeleteTrFirewallV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTrFirewallV2Request is the request struct for api DeleteTrFirewallV2
type DeleteTrFirewallV2Request struct {
	*requests.RpcRequest
	FirewallId string `position:"Query" name:"FirewallId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
}

// DeleteTrFirewallV2Response is the response struct for api DeleteTrFirewallV2
type DeleteTrFirewallV2Response struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTrFirewallV2Request creates a request to invoke DeleteTrFirewallV2 API
func CreateDeleteTrFirewallV2Request() (request *DeleteTrFirewallV2Request) {
	request = &DeleteTrFirewallV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DeleteTrFirewallV2", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTrFirewallV2Response creates a response to parse from DeleteTrFirewallV2 response
func CreateDeleteTrFirewallV2Response() (response *DeleteTrFirewallV2Response) {
	response = &DeleteTrFirewallV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
