package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaobaoUserMap invokes the cloudcallcenter.UpdateTaobaoUserMap API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaousermap.html
func (client *Client) UpdateTaobaoUserMap(request *UpdateTaobaoUserMapRequest) (response *UpdateTaobaoUserMapResponse, err error) {
	response = CreateUpdateTaobaoUserMapResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaobaoUserMapWithChan invokes the cloudcallcenter.UpdateTaobaoUserMap API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaousermap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTaobaoUserMapWithChan(request *UpdateTaobaoUserMapRequest) (<-chan *UpdateTaobaoUserMapResponse, <-chan error) {
	responseChan := make(chan *UpdateTaobaoUserMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaobaoUserMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaobaoUserMapWithCallback invokes the cloudcallcenter.UpdateTaobaoUserMap API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaousermap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTaobaoUserMapWithCallback(request *UpdateTaobaoUserMapRequest, callback func(response *UpdateTaobaoUserMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaobaoUserMapResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaobaoUserMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaobaoUserMapRequest is the request struct for api UpdateTaobaoUserMap
type UpdateTaobaoUserMapRequest struct {
	*requests.RpcRequest
	TaobaoUid requests.Integer `position:"Query" name:"taobaoUid"`
	Status    requests.Integer `position:"Query" name:"status"`
}

// UpdateTaobaoUserMapResponse is the response struct for api UpdateTaobaoUserMap
type UpdateTaobaoUserMapResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Id             int64  `json:"Id" xml:"Id"`
	Count          int    `json:"Count" xml:"Count"`
}

// CreateUpdateTaobaoUserMapRequest creates a request to invoke UpdateTaobaoUserMap API
func CreateUpdateTaobaoUserMapRequest() (request *UpdateTaobaoUserMapRequest) {
	request = &UpdateTaobaoUserMapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "UpdateTaobaoUserMap", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTaobaoUserMapResponse creates a response to parse from UpdateTaobaoUserMap response
func CreateUpdateTaobaoUserMapResponse() (response *UpdateTaobaoUserMapResponse) {
	response = &UpdateTaobaoUserMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
