package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCabServiceStatus invokes the cloudcallcenter.UpdateCabServiceStatus API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatecabservicestatus.html
func (client *Client) UpdateCabServiceStatus(request *UpdateCabServiceStatusRequest) (response *UpdateCabServiceStatusResponse, err error) {
	response = CreateUpdateCabServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCabServiceStatusWithChan invokes the cloudcallcenter.UpdateCabServiceStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatecabservicestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateCabServiceStatusWithChan(request *UpdateCabServiceStatusRequest) (<-chan *UpdateCabServiceStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateCabServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCabServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCabServiceStatusWithCallback invokes the cloudcallcenter.UpdateCabServiceStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatecabservicestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateCabServiceStatusWithCallback(request *UpdateCabServiceStatusRequest, callback func(response *UpdateCabServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCabServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateCabServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCabServiceStatusRequest is the request struct for api UpdateCabServiceStatus
type UpdateCabServiceStatusRequest struct {
	*requests.RpcRequest
	Suspend requests.Boolean `position:"Query" name:"Suspend"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// UpdateCabServiceStatusResponse is the response struct for api UpdateCabServiceStatus
type UpdateCabServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateUpdateCabServiceStatusRequest creates a request to invoke UpdateCabServiceStatus API
func CreateUpdateCabServiceStatusRequest() (request *UpdateCabServiceStatusRequest) {
	request = &UpdateCabServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "UpdateCabServiceStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateCabServiceStatusResponse creates a response to parse from UpdateCabServiceStatus response
func CreateUpdateCabServiceStatusResponse() (response *UpdateCabServiceStatusResponse) {
	response = &UpdateCabServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
