package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransformTtsToWav invokes the cloudcallcenter.TransformTtsToWav API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/transformttstowav.html
func (client *Client) TransformTtsToWav(request *TransformTtsToWavRequest) (response *TransformTtsToWavResponse, err error) {
	response = CreateTransformTtsToWavResponse()
	err = client.DoAction(request, response)
	return
}

// TransformTtsToWavWithChan invokes the cloudcallcenter.TransformTtsToWav API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/transformttstowav.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TransformTtsToWavWithChan(request *TransformTtsToWavRequest) (<-chan *TransformTtsToWavResponse, <-chan error) {
	responseChan := make(chan *TransformTtsToWavResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransformTtsToWav(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransformTtsToWavWithCallback invokes the cloudcallcenter.TransformTtsToWav API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/transformttstowav.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TransformTtsToWavWithCallback(request *TransformTtsToWavRequest, callback func(response *TransformTtsToWavResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransformTtsToWavResponse
		var err error
		defer close(result)
		response, err = client.TransformTtsToWav(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransformTtsToWavRequest is the request struct for api TransformTtsToWav
type TransformTtsToWavRequest struct {
	*requests.RpcRequest
	Tts        string `position:"Query" name:"Tts"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// TransformTtsToWavResponse is the response struct for api TransformTtsToWav
type TransformTtsToWavResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	WavName        string `json:"WavName" xml:"WavName"`
}

// CreateTransformTtsToWavRequest creates a request to invoke TransformTtsToWav API
func CreateTransformTtsToWavRequest() (request *TransformTtsToWavRequest) {
	request = &TransformTtsToWavRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "TransformTtsToWav", "", "")
	request.Method = requests.POST
	return
}

// CreateTransformTtsToWavResponse creates a response to parse from TransformTtsToWav response
func CreateTransformTtsToWavResponse() (response *TransformTtsToWavResponse) {
	response = &TransformTtsToWavResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
