package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTbAliyunUserMappingByTbUid invokes the cloudcallcenter.GetTbAliyunUserMappingByTbUid API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/gettbaliyunusermappingbytbuid.html
func (client *Client) GetTbAliyunUserMappingByTbUid(request *GetTbAliyunUserMappingByTbUidRequest) (response *GetTbAliyunUserMappingByTbUidResponse, err error) {
	response = CreateGetTbAliyunUserMappingByTbUidResponse()
	err = client.DoAction(request, response)
	return
}

// GetTbAliyunUserMappingByTbUidWithChan invokes the cloudcallcenter.GetTbAliyunUserMappingByTbUid API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/gettbaliyunusermappingbytbuid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTbAliyunUserMappingByTbUidWithChan(request *GetTbAliyunUserMappingByTbUidRequest) (<-chan *GetTbAliyunUserMappingByTbUidResponse, <-chan error) {
	responseChan := make(chan *GetTbAliyunUserMappingByTbUidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTbAliyunUserMappingByTbUid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTbAliyunUserMappingByTbUidWithCallback invokes the cloudcallcenter.GetTbAliyunUserMappingByTbUid API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/gettbaliyunusermappingbytbuid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTbAliyunUserMappingByTbUidWithCallback(request *GetTbAliyunUserMappingByTbUidRequest, callback func(response *GetTbAliyunUserMappingByTbUidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTbAliyunUserMappingByTbUidResponse
		var err error
		defer close(result)
		response, err = client.GetTbAliyunUserMappingByTbUid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTbAliyunUserMappingByTbUidRequest is the request struct for api GetTbAliyunUserMappingByTbUid
type GetTbAliyunUserMappingByTbUidRequest struct {
	*requests.RpcRequest
	TbUserid requests.Integer `position:"Query" name:"TbUserid"`
}

// GetTbAliyunUserMappingByTbUidResponse is the response struct for api GetTbAliyunUserMappingByTbUid
type GetTbAliyunUserMappingByTbUidResponse struct {
	*responses.BaseResponse
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	Success                    bool   `json:"Success" xml:"Success"`
	Code                       string `json:"Code" xml:"Code"`
	Message                    string `json:"Message" xml:"Message"`
	HttpStatusCode             int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Id                         int64  `json:"Id" xml:"Id"`
	TbUserid                   int64  `json:"TbUserid" xml:"TbUserid"`
	TbNickname                 string `json:"TbNickname" xml:"TbNickname"`
	AliyunPk                   int64  `json:"AliyunPk" xml:"AliyunPk"`
	SubAccount                 bool   `json:"SubAccount" xml:"SubAccount"`
	PrimaryAccountPk           int64  `json:"PrimaryAccountPk" xml:"PrimaryAccountPk"`
	AliyunAkId                 string `json:"AliyunAkId" xml:"AliyunAkId"`
	AliyunAkSecret             string `json:"AliyunAkSecret" xml:"AliyunAkSecret"`
	TaobaoAccessToken          string `json:"TaobaoAccessToken" xml:"TaobaoAccessToken"`
	TaobaoAccessTokenExpiresIn int    `json:"TaobaoAccessTokenExpiresIn" xml:"TaobaoAccessTokenExpiresIn"`
	TaobaoAccessTokenCreate    int64  `json:"TaobaoAccessTokenCreate" xml:"TaobaoAccessTokenCreate"`
}

// CreateGetTbAliyunUserMappingByTbUidRequest creates a request to invoke GetTbAliyunUserMappingByTbUid API
func CreateGetTbAliyunUserMappingByTbUidRequest() (request *GetTbAliyunUserMappingByTbUidRequest) {
	request = &GetTbAliyunUserMappingByTbUidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetTbAliyunUserMappingByTbUid", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTbAliyunUserMappingByTbUidResponse creates a response to parse from GetTbAliyunUserMappingByTbUid response
func CreateGetTbAliyunUserMappingByTbUidResponse() (response *GetTbAliyunUserMappingByTbUidResponse) {
	response = &GetTbAliyunUserMappingByTbUidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
