package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Mobile3MetaDetailVerify invokes the cloudauth.Mobile3MetaDetailVerify API synchronously
func (client *Client) Mobile3MetaDetailVerify(request *Mobile3MetaDetailVerifyRequest) (response *Mobile3MetaDetailVerifyResponse, err error) {
	response = CreateMobile3MetaDetailVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// Mobile3MetaDetailVerifyWithChan invokes the cloudauth.Mobile3MetaDetailVerify API asynchronously
func (client *Client) Mobile3MetaDetailVerifyWithChan(request *Mobile3MetaDetailVerifyRequest) (<-chan *Mobile3MetaDetailVerifyResponse, <-chan error) {
	responseChan := make(chan *Mobile3MetaDetailVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Mobile3MetaDetailVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Mobile3MetaDetailVerifyWithCallback invokes the cloudauth.Mobile3MetaDetailVerify API asynchronously
func (client *Client) Mobile3MetaDetailVerifyWithCallback(request *Mobile3MetaDetailVerifyRequest, callback func(response *Mobile3MetaDetailVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Mobile3MetaDetailVerifyResponse
		var err error
		defer close(result)
		response, err = client.Mobile3MetaDetailVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Mobile3MetaDetailVerifyRequest is the request struct for api Mobile3MetaDetailVerify
type Mobile3MetaDetailVerifyRequest struct {
	*requests.RpcRequest
	ParamType   string `position:"Query" name:"ParamType"`
	Mobile      string `position:"Query" name:"Mobile"`
	IdentifyNum string `position:"Query" name:"IdentifyNum"`
	UserName    string `position:"Query" name:"UserName"`
}

// Mobile3MetaDetailVerifyResponse is the response struct for api Mobile3MetaDetailVerify
type Mobile3MetaDetailVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateMobile3MetaDetailVerifyRequest creates a request to invoke Mobile3MetaDetailVerify API
func CreateMobile3MetaDetailVerifyRequest() (request *Mobile3MetaDetailVerifyRequest) {
	request = &Mobile3MetaDetailVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "Mobile3MetaDetailVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMobile3MetaDetailVerifyResponse creates a response to parse from Mobile3MetaDetailVerify response
func CreateMobile3MetaDetailVerifyResponse() (response *Mobile3MetaDetailVerifyResponse) {
	response = &Mobile3MetaDetailVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
