package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceLatency invokes the cloudapi.DescribeInstanceLatency API synchronously
func (client *Client) DescribeInstanceLatency(request *DescribeInstanceLatencyRequest) (response *DescribeInstanceLatencyResponse, err error) {
	response = CreateDescribeInstanceLatencyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceLatencyWithChan invokes the cloudapi.DescribeInstanceLatency API asynchronously
func (client *Client) DescribeInstanceLatencyWithChan(request *DescribeInstanceLatencyRequest) (<-chan *DescribeInstanceLatencyResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceLatencyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceLatency(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceLatencyWithCallback invokes the cloudapi.DescribeInstanceLatency API asynchronously
func (client *Client) DescribeInstanceLatencyWithCallback(request *DescribeInstanceLatencyRequest, callback func(response *DescribeInstanceLatencyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceLatencyResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceLatency(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceLatencyRequest is the request struct for api DescribeInstanceLatency
type DescribeInstanceLatencyRequest struct {
	*requests.RpcRequest
	StageName     string `position:"Query" name:"StageName"`
	EndTime       string `position:"Query" name:"EndTime"`
	StartTime     string `position:"Query" name:"StartTime"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeInstanceLatencyResponse is the response struct for api DescribeInstanceLatency
type DescribeInstanceLatencyResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	InstanceLatency InstanceLatency `json:"InstanceLatency" xml:"InstanceLatency"`
}

// CreateDescribeInstanceLatencyRequest creates a request to invoke DescribeInstanceLatency API
func CreateDescribeInstanceLatencyRequest() (request *DescribeInstanceLatencyRequest) {
	request = &DescribeInstanceLatencyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeInstanceLatency", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceLatencyResponse creates a response to parse from DescribeInstanceLatency response
func CreateDescribeInstanceLatencyResponse() (response *DescribeInstanceLatencyResponse) {
	response = &DescribeInstanceLatencyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
