package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterConfig invokes the clickhouse.DescribeDBClusterConfig API synchronously
func (client *Client) DescribeDBClusterConfig(request *DescribeDBClusterConfigRequest) (response *DescribeDBClusterConfigResponse, err error) {
	response = CreateDescribeDBClusterConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterConfigWithChan invokes the clickhouse.DescribeDBClusterConfig API asynchronously
func (client *Client) DescribeDBClusterConfigWithChan(request *DescribeDBClusterConfigRequest) (<-chan *DescribeDBClusterConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterConfigWithCallback invokes the clickhouse.DescribeDBClusterConfig API asynchronously
func (client *Client) DescribeDBClusterConfigWithCallback(request *DescribeDBClusterConfigRequest, callback func(response *DescribeDBClusterConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterConfigRequest is the request struct for api DescribeDBClusterConfig
type DescribeDBClusterConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBClusterConfigResponse is the response struct for api DescribeDBClusterConfig
type DescribeDBClusterConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Config    string `json:"Config" xml:"Config"`
}

// CreateDescribeDBClusterConfigRequest creates a request to invoke DescribeDBClusterConfig API
func CreateDescribeDBClusterConfigRequest() (request *DescribeDBClusterConfigRequest) {
	request = &DescribeDBClusterConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeDBClusterConfig", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterConfigResponse creates a response to parse from DescribeDBClusterConfig response
func CreateDescribeDBClusterConfigResponse() (response *DescribeDBClusterConfigResponse) {
	response = &DescribeDBClusterConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
