package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPersonTop invokes the cdrs.ListPersonTop API synchronously
func (client *Client) ListPersonTop(request *ListPersonTopRequest) (response *ListPersonTopResponse, err error) {
	response = CreateListPersonTopResponse()
	err = client.DoAction(request, response)
	return
}

// ListPersonTopWithChan invokes the cdrs.ListPersonTop API asynchronously
func (client *Client) ListPersonTopWithChan(request *ListPersonTopRequest) (<-chan *ListPersonTopResponse, <-chan error) {
	responseChan := make(chan *ListPersonTopResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPersonTop(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPersonTopWithCallback invokes the cdrs.ListPersonTop API asynchronously
func (client *Client) ListPersonTopWithCallback(request *ListPersonTopRequest, callback func(response *ListPersonTopResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPersonTopResponse
		var err error
		defer close(result)
		response, err = client.ListPersonTop(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPersonTopRequest is the request struct for api ListPersonTop
type ListPersonTopRequest struct {
	*requests.RpcRequest
	Schema     string `position:"Body" name:"Schema"`
	CorpId     string `position:"Body" name:"CorpId"`
	EndTime    string `position:"Body" name:"EndTime"`
	StartTime  string `position:"Body" name:"StartTime"`
	PageNumber string `position:"Body" name:"PageNumber"`
	PageSize   string `position:"Body" name:"PageSize"`
	PersonId   string `position:"Body" name:"PersonId"`
}

// ListPersonTopResponse is the response struct for api ListPersonTop
type ListPersonTopResponse struct {
	*responses.BaseResponse
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNumber int64      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64      `json:"PageSize" xml:"PageSize"`
	TotalCount int64      `json:"TotalCount" xml:"TotalCount"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateListPersonTopRequest creates a request to invoke ListPersonTop API
func CreateListPersonTopRequest() (request *ListPersonTopRequest) {
	request = &ListPersonTopRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListPersonTop", "", "")
	request.Method = requests.POST
	return
}

// CreateListPersonTopResponse creates a response to parse from ListPersonTop response
func CreateListPersonTopResponse() (response *ListPersonTopResponse) {
	response = &ListPersonTopResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
