package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCityMapAois invokes the cdrs.ListCityMapAois API synchronously
func (client *Client) ListCityMapAois(request *ListCityMapAoisRequest) (response *ListCityMapAoisResponse, err error) {
	response = CreateListCityMapAoisResponse()
	err = client.DoAction(request, response)
	return
}

// ListCityMapAoisWithChan invokes the cdrs.ListCityMapAois API asynchronously
func (client *Client) ListCityMapAoisWithChan(request *ListCityMapAoisRequest) (<-chan *ListCityMapAoisResponse, <-chan error) {
	responseChan := make(chan *ListCityMapAoisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCityMapAois(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCityMapAoisWithCallback invokes the cdrs.ListCityMapAois API asynchronously
func (client *Client) ListCityMapAoisWithCallback(request *ListCityMapAoisRequest, callback func(response *ListCityMapAoisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCityMapAoisResponse
		var err error
		defer close(result)
		response, err = client.ListCityMapAois(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCityMapAoisRequest is the request struct for api ListCityMapAois
type ListCityMapAoisRequest struct {
	*requests.RpcRequest
	Latitude  string           `position:"Body" name:"Latitude"`
	Radius    requests.Integer `position:"Body" name:"Radius"`
	Longitude string           `position:"Body" name:"Longitude"`
}

// ListCityMapAoisResponse is the response struct for api ListCityMapAois
type ListCityMapAoisResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListCityMapAoisRequest creates a request to invoke ListCityMapAois API
func CreateListCityMapAoisRequest() (request *ListCityMapAoisRequest) {
	request = &ListCityMapAoisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListCityMapAois", "", "")
	request.Method = requests.POST
	return
}

// CreateListCityMapAoisResponse creates a response to parse from ListCityMapAois response
func CreateListCityMapAoisResponse() (response *ListCityMapAoisResponse) {
	response = &ListCityMapAoisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
