package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeNetLink invokes the cc5g.RevokeNetLink API synchronously
func (client *Client) RevokeNetLink(request *RevokeNetLinkRequest) (response *RevokeNetLinkResponse, err error) {
	response = CreateRevokeNetLinkResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeNetLinkWithChan invokes the cc5g.RevokeNetLink API asynchronously
func (client *Client) RevokeNetLinkWithChan(request *RevokeNetLinkRequest) (<-chan *RevokeNetLinkResponse, <-chan error) {
	responseChan := make(chan *RevokeNetLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeNetLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeNetLinkWithCallback invokes the cc5g.RevokeNetLink API asynchronously
func (client *Client) RevokeNetLinkWithCallback(request *RevokeNetLinkRequest, callback func(response *RevokeNetLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeNetLinkResponse
		var err error
		defer close(result)
		response, err = client.RevokeNetLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeNetLinkRequest is the request struct for api RevokeNetLink
type RevokeNetLinkRequest struct {
	*requests.RpcRequest
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	NetLinkId                string           `position:"Query" name:"NetLinkId"`
	ClientToken              string           `position:"Query" name:"ClientToken"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
}

// RevokeNetLinkResponse is the response struct for api RevokeNetLink
type RevokeNetLinkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeNetLinkRequest creates a request to invoke RevokeNetLink API
func CreateRevokeNetLinkRequest() (request *RevokeNetLinkRequest) {
	request = &RevokeNetLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "RevokeNetLink", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRevokeNetLinkResponse creates a response to parse from RevokeNetLink response
func CreateRevokeNetLinkResponse() (response *RevokeNetLinkResponse) {
	response = &RevokeNetLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
