package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCostBudgetsSummary invokes the bssopenapi.DescribeCostBudgetsSummary API synchronously
func (client *Client) DescribeCostBudgetsSummary(request *DescribeCostBudgetsSummaryRequest) (response *DescribeCostBudgetsSummaryResponse, err error) {
	response = CreateDescribeCostBudgetsSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCostBudgetsSummaryWithChan invokes the bssopenapi.DescribeCostBudgetsSummary API asynchronously
func (client *Client) DescribeCostBudgetsSummaryWithChan(request *DescribeCostBudgetsSummaryRequest) (<-chan *DescribeCostBudgetsSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeCostBudgetsSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCostBudgetsSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCostBudgetsSummaryWithCallback invokes the bssopenapi.DescribeCostBudgetsSummary API asynchronously
func (client *Client) DescribeCostBudgetsSummaryWithCallback(request *DescribeCostBudgetsSummaryRequest, callback func(response *DescribeCostBudgetsSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCostBudgetsSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeCostBudgetsSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCostBudgetsSummaryRequest is the request struct for api DescribeCostBudgetsSummary
type DescribeCostBudgetsSummaryRequest struct {
	*requests.RpcRequest
	BudgetStatus string           `position:"Query" name:"BudgetStatus"`
	BudgetType   string           `position:"Query" name:"BudgetType"`
	NextToken    string           `position:"Query" name:"NextToken"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
	BudgetName   string           `position:"Query" name:"BudgetName"`
}

// DescribeCostBudgetsSummaryResponse is the response struct for api DescribeCostBudgetsSummary
type DescribeCostBudgetsSummaryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeCostBudgetsSummaryRequest creates a request to invoke DescribeCostBudgetsSummary API
func CreateDescribeCostBudgetsSummaryRequest() (request *DescribeCostBudgetsSummaryRequest) {
	request = &DescribeCostBudgetsSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeCostBudgetsSummary", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCostBudgetsSummaryResponse creates a response to parse from DescribeCostBudgetsSummary response
func CreateDescribeCostBudgetsSummaryResponse() (response *DescribeCostBudgetsSummaryResponse) {
	response = &DescribeCostBudgetsSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
