package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricInvitationCode invokes the baas.DescribeFabricInvitationCode API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricinvitationcode.html
func (client *Client) DescribeFabricInvitationCode(request *DescribeFabricInvitationCodeRequest) (response *DescribeFabricInvitationCodeResponse, err error) {
	response = CreateDescribeFabricInvitationCodeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricInvitationCodeWithChan invokes the baas.DescribeFabricInvitationCode API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricinvitationcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricInvitationCodeWithChan(request *DescribeFabricInvitationCodeRequest) (<-chan *DescribeFabricInvitationCodeResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricInvitationCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricInvitationCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricInvitationCodeWithCallback invokes the baas.DescribeFabricInvitationCode API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricinvitationcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricInvitationCodeWithCallback(request *DescribeFabricInvitationCodeRequest, callback func(response *DescribeFabricInvitationCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricInvitationCodeResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricInvitationCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricInvitationCodeRequest is the request struct for api DescribeFabricInvitationCode
type DescribeFabricInvitationCodeRequest struct {
	*requests.RpcRequest
	ConsortiumId string `position:"Body" name:"ConsortiumId"`
}

// DescribeFabricInvitationCodeResponse is the response struct for api DescribeFabricInvitationCode
type DescribeFabricInvitationCodeResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      int    `json:"ErrorCode" xml:"ErrorCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Result         Result `json:"Result" xml:"Result"`
}

// CreateDescribeFabricInvitationCodeRequest creates a request to invoke DescribeFabricInvitationCode API
func CreateDescribeFabricInvitationCodeRequest() (request *DescribeFabricInvitationCodeRequest) {
	request = &DescribeFabricInvitationCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricInvitationCode", "baas", "openAPI")
	return
}

// CreateDescribeFabricInvitationCodeResponse creates a response to parse from DescribeFabricInvitationCode response
func CreateDescribeFabricInvitationCodeResponse() (response *DescribeFabricInvitationCodeResponse) {
	response = &DescribeFabricInvitationCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
