package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebhookContacts invokes the arms.DescribeWebhookContacts API synchronously
func (client *Client) DescribeWebhookContacts(request *DescribeWebhookContactsRequest) (response *DescribeWebhookContactsResponse, err error) {
	response = CreateDescribeWebhookContactsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebhookContactsWithChan invokes the arms.DescribeWebhookContacts API asynchronously
func (client *Client) DescribeWebhookContactsWithChan(request *DescribeWebhookContactsRequest) (<-chan *DescribeWebhookContactsResponse, <-chan error) {
	responseChan := make(chan *DescribeWebhookContactsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebhookContacts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebhookContactsWithCallback invokes the arms.DescribeWebhookContacts API asynchronously
func (client *Client) DescribeWebhookContactsWithCallback(request *DescribeWebhookContactsRequest, callback func(response *DescribeWebhookContactsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebhookContactsResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebhookContacts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebhookContactsRequest is the request struct for api DescribeWebhookContacts
type DescribeWebhookContactsRequest struct {
	*requests.RpcRequest
	Size        requests.Integer `position:"Query" name:"Size"`
	WebhookName string           `position:"Query" name:"WebhookName"`
	Page        requests.Integer `position:"Query" name:"Page"`
	ContactIds  string           `position:"Query" name:"ContactIds"`
}

// DescribeWebhookContactsResponse is the response struct for api DescribeWebhookContacts
type DescribeWebhookContactsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageBean  PageBean `json:"PageBean" xml:"PageBean"`
}

// CreateDescribeWebhookContactsRequest creates a request to invoke DescribeWebhookContacts API
func CreateDescribeWebhookContactsRequest() (request *DescribeWebhookContactsRequest) {
	request = &DescribeWebhookContactsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DescribeWebhookContacts", "arms", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeWebhookContactsResponse creates a response to parse from DescribeWebhookContacts response
func CreateDescribeWebhookContactsResponse() (response *DescribeWebhookContactsResponse) {
	response = &DescribeWebhookContactsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
