package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAppInstanceGroup invokes the appstream_center.CreateAppInstanceGroup API synchronously
func (client *Client) CreateAppInstanceGroup(request *CreateAppInstanceGroupRequest) (response *CreateAppInstanceGroupResponse, err error) {
	response = CreateCreateAppInstanceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAppInstanceGroupWithChan invokes the appstream_center.CreateAppInstanceGroup API asynchronously
func (client *Client) CreateAppInstanceGroupWithChan(request *CreateAppInstanceGroupRequest) (<-chan *CreateAppInstanceGroupResponse, <-chan error) {
	responseChan := make(chan *CreateAppInstanceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAppInstanceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAppInstanceGroupWithCallback invokes the appstream_center.CreateAppInstanceGroup API asynchronously
func (client *Client) CreateAppInstanceGroupWithCallback(request *CreateAppInstanceGroupRequest, callback func(response *CreateAppInstanceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAppInstanceGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateAppInstanceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAppInstanceGroupRequest is the request struct for api CreateAppInstanceGroup
type CreateAppInstanceGroupRequest struct {
	*requests.RpcRequest
	RuntimePolicy               CreateAppInstanceGroupRuntimePolicy  `position:"Body" name:"RuntimePolicy"  type:"Struct"`
	BizRegionId                 string                               `position:"Body" name:"BizRegionId"`
	ScalingStep                 requests.Integer                     `position:"Body" name:"ScalingStep"`
	ScalingDownAfterIdleMinutes requests.Integer                     `position:"Body" name:"ScalingDownAfterIdleMinutes"`
	MinAmount                   requests.Integer                     `position:"Body" name:"MinAmount"`
	ProductType                 string                               `position:"Body" name:"ProductType"`
	Network                     CreateAppInstanceGroupNetwork        `position:"Body" name:"Network"  type:"Struct"`
	ReserveMinAmount            requests.Integer                     `position:"Body" name:"ReserveMinAmount"`
	SessionTimeout              requests.Integer                     `position:"Body" name:"SessionTimeout"`
	ChargeResourceMode          string                               `position:"Body" name:"ChargeResourceMode"`
	AppCenterImageId            string                               `position:"Body" name:"AppCenterImageId"`
	ScalingUsageThreshold       string                               `position:"Body" name:"ScalingUsageThreshold"`
	UserInfo                    CreateAppInstanceGroupUserInfo       `position:"Body" name:"UserInfo"  type:"Struct"`
	ReserveAmountRatio          string                               `position:"Body" name:"ReserveAmountRatio"`
	PreOpenAppId                string                               `position:"Body" name:"PreOpenAppId"`
	Amount                      requests.Integer                     `position:"Body" name:"Amount"`
	Period                      requests.Integer                     `position:"Body" name:"Period"`
	AutoPay                     requests.Boolean                     `position:"Body" name:"AutoPay"`
	NodePool                    CreateAppInstanceGroupNodePool       `position:"Body" name:"NodePool"  type:"Struct"`
	AppInstanceType             string                               `position:"Body" name:"AppInstanceType"`
	MaxAmount                   requests.Integer                     `position:"Body" name:"MaxAmount"`
	SecurityPolicy              CreateAppInstanceGroupSecurityPolicy `position:"Body" name:"SecurityPolicy"  type:"Struct"`
	PromotionId                 string                               `position:"Body" name:"PromotionId"`
	Users                       *[]string                            `position:"Body" name:"Users"  type:"Repeated"`
	VideoPolicy                 CreateAppInstanceGroupVideoPolicy    `position:"Body" name:"VideoPolicy"  type:"Struct"`
	AppInstanceGroupName        string                               `position:"Body" name:"AppInstanceGroupName"`
	PeriodUnit                  string                               `position:"Body" name:"PeriodUnit"`
	ReserveMaxAmount            requests.Integer                     `position:"Body" name:"ReserveMaxAmount"`
	AutoRenew                   requests.Boolean                     `position:"Body" name:"AutoRenew"`
	ChargeType                  string                               `position:"Body" name:"ChargeType"`
	StrategyType                string                               `position:"Body" name:"StrategyType"`
}

// CreateAppInstanceGroupRuntimePolicy is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupRuntimePolicy struct {
	SessionType string `name:"SessionType"`
	DebugMode   string `name:"DebugMode"`
}

// CreateAppInstanceGroupNetwork is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupNetwork struct {
	Routes       *[]CreateAppInstanceGroupNetworkRoutesItem `name:"Routes" type:"Repeated"`
	StrategyType string                                     `name:"StrategyType"`
}

// CreateAppInstanceGroupUserInfo is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupUserInfo struct {
	Type string `name:"Type"`
}

// CreateAppInstanceGroupNodePool is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupNodePool struct {
	RecurrenceSchedules         *[]CreateAppInstanceGroupNodePoolRecurrenceSchedulesItem `name:"RecurrenceSchedules" type:"Repeated"`
	NodeAmount                  string                                                   `name:"NodeAmount"`
	ScalingStep                 string                                                   `name:"ScalingStep"`
	StrategyDisableDate         string                                                   `name:"StrategyDisableDate"`
	NodeInstanceType            string                                                   `name:"NodeInstanceType"`
	ScalingDownAfterIdleMinutes string                                                   `name:"ScalingDownAfterIdleMinutes"`
	StrategyType                string                                                   `name:"StrategyType"`
	MaxScalingAmount            string                                                   `name:"MaxScalingAmount"`
	WarmUp                      string                                                   `name:"WarmUp"`
	ScalingUsageThreshold       string                                                   `name:"ScalingUsageThreshold"`
	NodeCapacity                string                                                   `name:"NodeCapacity"`
	StrategyEnableDate          string                                                   `name:"StrategyEnableDate"`
}

// CreateAppInstanceGroupSecurityPolicy is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupSecurityPolicy struct {
	ResetAfterUnbind string `name:"ResetAfterUnbind"`
}

// CreateAppInstanceGroupVideoPolicy is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupVideoPolicy struct {
	Webrtc                     string `name:"Webrtc"`
	TerminalResolutionAdaptive string `name:"TerminalResolutionAdaptive"`
	FrameRate                  string `name:"FrameRate"`
	SessionResolutionWidth     string `name:"SessionResolutionWidth"`
	StreamingMode              string `name:"StreamingMode"`
	SessionResolutionHeight    string `name:"SessionResolutionHeight"`
}

// CreateAppInstanceGroupNetworkRoutesItem is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupNetworkRoutesItem struct {
	Mode        string `name:"Mode"`
	Destination string `name:"Destination"`
}

// CreateAppInstanceGroupNodePoolRecurrenceSchedulesItem is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupNodePoolRecurrenceSchedulesItem struct {
	RecurrenceValues *[]string                                                                `name:"RecurrenceValues" type:"Repeated"`
	RecurrenceType   string                                                                   `name:"RecurrenceType"`
	TimerPeriods     *[]CreateAppInstanceGroupNodePoolRecurrenceSchedulesItemTimerPeriodsItem `name:"TimerPeriods" type:"Repeated"`
}

// CreateAppInstanceGroupNodePoolRecurrenceSchedulesItemTimerPeriodsItem is a repeated param struct in CreateAppInstanceGroupRequest
type CreateAppInstanceGroupNodePoolRecurrenceSchedulesItemTimerPeriodsItem struct {
	Amount    string `name:"Amount"`
	EndTime   string `name:"EndTime"`
	StartTime string `name:"StartTime"`
}

// CreateAppInstanceGroupResponse is the response struct for api CreateAppInstanceGroup
type CreateAppInstanceGroupResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	AppInstanceGroupModel AppInstanceGroupModel `json:"AppInstanceGroupModel" xml:"AppInstanceGroupModel"`
}

// CreateCreateAppInstanceGroupRequest creates a request to invoke CreateAppInstanceGroup API
func CreateCreateAppInstanceGroupRequest() (request *CreateAppInstanceGroupRequest) {
	request = &CreateAppInstanceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "CreateAppInstanceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAppInstanceGroupResponse creates a response to parse from CreateAppInstanceGroup response
func CreateCreateAppInstanceGroupResponse() (response *CreateAppInstanceGroupResponse) {
	response = &CreateAppInstanceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
