package appmallsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMessages invokes the appmallsservice.GetMessages API synchronously
// api document: https://help.aliyun.com/api/appmallsservice/getmessages.html
func (client *Client) GetMessages(request *GetMessagesRequest) (response *GetMessagesResponse, err error) {
	response = CreateGetMessagesResponse()
	err = client.DoAction(request, response)
	return
}

// GetMessagesWithChan invokes the appmallsservice.GetMessages API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/getmessages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMessagesWithChan(request *GetMessagesRequest) (<-chan *GetMessagesResponse, <-chan error) {
	responseChan := make(chan *GetMessagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMessages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMessagesWithCallback invokes the appmallsservice.GetMessages API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/getmessages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMessagesWithCallback(request *GetMessagesRequest, callback func(response *GetMessagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMessagesResponse
		var err error
		defer close(result)
		response, err = client.GetMessages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMessagesRequest is the request struct for api GetMessages
type GetMessagesRequest struct {
	*requests.RpcRequest
	Topic      string `position:"Query" name:"Topic"`
	ParamsJson string `position:"Query" name:"ParamsJson"`
}

// GetMessagesResponse is the response struct for api GetMessages
type GetMessagesResponse struct {
	*responses.BaseResponse
	ErrorCode   string            `json:"ErrorCode" xml:"ErrorCode"`
	Msg         string            `json:"Msg" xml:"Msg"`
	SubCode     string            `json:"SubCode" xml:"SubCode"`
	SubMsg      string            `json:"SubMsg" xml:"SubMsg"`
	LogsId      string            `json:"LogsId" xml:"LogsId"`
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	BizMessages []BizMessagesItem `json:"BizMessages" xml:"BizMessages"`
}

// CreateGetMessagesRequest creates a request to invoke GetMessages API
func CreateGetMessagesRequest() (request *GetMessagesRequest) {
	request = &GetMessagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AppMallsService", "2018-02-24", "GetMessages", "", "")
	return
}

// CreateGetMessagesResponse creates a response to parse from GetMessages response
func CreateGetMessagesResponse() (response *GetMessagesResponse) {
	response = &GetMessagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
