package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRegions invokes the apds.ListRegions API synchronously
func (client *Client) ListRegions(request *ListRegionsRequest) (response *ListRegionsResponse, err error) {
	response = CreateListRegionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRegionsWithChan invokes the apds.ListRegions API asynchronously
func (client *Client) ListRegionsWithChan(request *ListRegionsRequest) (<-chan *ListRegionsResponse, <-chan error) {
	responseChan := make(chan *ListRegionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRegions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRegionsWithCallback invokes the apds.ListRegions API asynchronously
func (client *Client) ListRegionsWithCallback(request *ListRegionsRequest, callback func(response *ListRegionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRegionsResponse
		var err error
		defer close(result)
		response, err = client.ListRegions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRegionsRequest is the request struct for api ListRegions
type ListRegionsRequest struct {
	*requests.RoaRequest
	CloudType string `position:"Query" name:"cloudType"`
	Ak        string `position:"Query" name:"ak"`
	Sk        string `position:"Query" name:"sk"`
	TenantId  string `position:"Query" name:"tenantId"`
	Region    string `position:"Query" name:"region"`
}

// ListRegionsResponse is the response struct for api ListRegions
type ListRegionsResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateListRegionsRequest creates a request to invoke ListRegions API
func CreateListRegionsRequest() (request *ListRegionsRequest) {
	request = &ListRegionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "ListRegions", "/okss-services/winback/query-region", "", "")
	request.Method = requests.POST
	return
}

// CreateListRegionsResponse creates a response to parse from ListRegions response
func CreateListRegionsResponse() (response *ListRegionsResponse) {
	response = &ListRegionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
